/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.cpp.internal;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.language.ComponentDependencies;
import org.gradle.language.cpp.CppComponent;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.internal.DefaultCppComponent;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.DefaultComponentDependencies;
import org.gradle.nativeplatform.test.cpp.CppTestExecutable;
import org.gradle.nativeplatform.test.cpp.CppTestSuite;
import org.gradle.nativeplatform.test.cpp.internal.DefaultCppTestExecutable;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

public class DefaultCppTestSuite
extends DefaultCppComponent
implements CppTestSuite {
    private final ObjectFactory objectFactory;
    private final Property<CppComponent> testedComponent;
    private final Property<CppTestExecutable> testBinary;
    private final DefaultComponentDependencies dependencies;

    @Inject
    public DefaultCppTestSuite(String name, ObjectFactory objectFactory, FileOperations fileOperations) {
        super(name, fileOperations, objectFactory);
        this.objectFactory = objectFactory;
        this.testedComponent = objectFactory.property(CppComponent.class);
        this.testBinary = objectFactory.property(CppTestExecutable.class);
        this.dependencies = objectFactory.newInstance(DefaultComponentDependencies.class, this.getNames().withSuffix("implementation"));
    }

    public CppTestExecutable addExecutable(String nameSuffix, NativeVariantIdentity identity, CppPlatform targetPlatform, NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider) {
        CppTestExecutable testBinary = this.objectFactory.newInstance(DefaultCppTestExecutable.class, this.getName() + StringUtils.capitalize((String)nameSuffix), this.getBaseName(), this.getCppSource(), this.getPrivateHeaderDirs(), this.getImplementationDependencies(), this.getTestedComponent(), targetPlatform, toolChain, platformToolProvider, identity);
        this.testBinary.set(testBinary);
        ((DefaultBinaryCollection)this.getBinaries()).add(testBinary);
        return testBinary;
    }

    @Override
    public DisplayName getDisplayName() {
        return Describables.withTypeAndName("C++ test suite", this.getName());
    }

    @Override
    public Configuration getImplementationDependencies() {
        return this.dependencies.getImplementationDependencies();
    }

    @Override
    public ComponentDependencies getDependencies() {
        return this.dependencies;
    }

    public void dependencies(Action<? super ComponentDependencies> action) {
        action.execute(this.dependencies);
    }

    public Property<CppComponent> getTestedComponent() {
        return this.testedComponent;
    }

    public Property<CppTestExecutable> getTestBinary() {
        return this.testBinary;
    }
}

