/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform;

import org.gradle.api.Incubating;
import org.gradle.api.Named;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.tasks.Input;

@Incubating
public abstract class OperatingSystemFamily
implements Named {
    public static final Attribute<OperatingSystemFamily> OPERATING_SYSTEM_ATTRIBUTE = Attribute.of("org.gradle.native.operatingSystem", OperatingSystemFamily.class);
    public static final String WINDOWS = "windows";
    public static final String LINUX = "linux";
    public static final String MACOS = "macos";

    @Override
    @Input
    public abstract String getName();

    public boolean isWindows() {
        return this.is(WINDOWS);
    }

    public boolean isLinux() {
        return this.is(LINUX);
    }

    public boolean isMacOs() {
        return this.is(MACOS);
    }

    private boolean is(String osFamily) {
        return this.getName().equals(osFamily);
    }
}

