/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.type;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.model.internal.type.TypeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassTypeWrapper
implements TypeWrapper {
    private final WeakReference<Class<?>> reference;
    private final int hashCode;

    public ClassTypeWrapper(Class<?> clazz) {
        Class<?> effectiveClass = this.effectiveClassOf(clazz);
        this.reference = new WeakReference(effectiveClass);
        this.hashCode = effectiveClass.hashCode();
    }

    public Class<?> unwrap() {
        return (Class)this.reference.get();
    }

    @Override
    public Class<?> getRawClass() {
        return this.unwrap();
    }

    @Override
    public boolean isAssignableFrom(TypeWrapper wrapper) {
        return this.unwrap().isAssignableFrom(wrapper.getRawClass());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ClassTypeWrapper other = (ClassTypeWrapper)obj;
        return this.unwrap().equals(other.unwrap());
    }

    @Override
    public void collectClasses(ImmutableList.Builder<Class<?>> builder) {
        builder.add(this.unwrap());
    }

    @Override
    public String getRepresentation(boolean full) {
        try {
            return this.tryToGetRepresentation(full);
        }
        catch (NoClassDefFoundError ignore) {
            Class<?> clazz = this.unwrap();
            Package pkg = clazz.getPackage();
            int pkgPrefixLength = pkg == null ? 0 : pkg.getName().length() + 1;
            String simpleName = clazz.getName().substring(pkgPrefixLength).replace('$', '.');
            return full && pkg != null ? pkg.getName() + "." + simpleName : simpleName;
        }
    }

    private String tryToGetRepresentation(boolean full) {
        ArrayList<Class<?>> classChain = this.getEnclosingClassChain();
        int topLevelIndex = classChain.size() - 1;
        Class<?> topLevelClass = classChain.get(topLevelIndex);
        StringBuilder representation = new StringBuilder();
        representation.append(full ? topLevelClass.getName() : topLevelClass.getSimpleName());
        for (int i = topLevelIndex - 1; i >= 0; --i) {
            representation.append('.');
            representation.append(classChain.get(i).getSimpleName());
        }
        return representation.toString();
    }

    private ArrayList<Class<?>> getEnclosingClassChain() {
        ArrayList classChain = new ArrayList();
        Class<?> clazz = this.unwrap();
        do {
            classChain.add(clazz);
        } while ((clazz = clazz.getEnclosingClass()) != null);
        return classChain;
    }

    private Class<?> effectiveClassOf(Class<?> clazz) {
        Class<?> enclosingClass = clazz.getEnclosingClass();
        if (enclosingClass != null && enclosingClass.isEnum() && clazz.getSuperclass() == enclosingClass) {
            return enclosingClass;
        }
        return clazz;
    }
}

