/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.configuration;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.logging.sink.ConsoleStateUtil;
import org.gradle.launcher.daemon.configuration.DaemonJvmOptions;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonParameters {
    static final int DEFAULT_IDLE_TIMEOUT = 10800000;
    public static final int DEFAULT_PERIODIC_CHECK_INTERVAL_MILLIS = 10000;
    public static final List<String> DEFAULT_JVM_ARGS = ImmutableList.of((Object)"-Xmx1024m", (Object)"-XX:MaxPermSize=256m", (Object)"-XX:+HeapDumpOnOutOfMemoryError");
    public static final List<String> DEFAULT_JVM_8_ARGS = ImmutableList.of((Object)"-Xmx1024m", (Object)"-XX:+HeapDumpOnOutOfMemoryError");
    private final File gradleUserHomeDir;
    private File baseDir;
    private int idleTimeout = 10800000;
    private int periodicCheckInterval = 10000;
    private final DaemonJvmOptions jvmOptions = new DaemonJvmOptions(new IdentityFileResolver());
    private Map<String, String> envVariables;
    private boolean enabled = true;
    private boolean hasJvmArgs;
    private boolean userDefinedImmutableJvmArgs;
    private boolean foreground;
    private boolean stop;
    private boolean status;
    private boolean interactive = ConsoleStateUtil.isInteractive();
    private JavaInfo jvm = Jvm.current();

    public DaemonParameters(BuildLayoutParameters layout) {
        this(layout, Collections.emptyMap());
    }

    public DaemonParameters(BuildLayoutParameters layout, Map<String, String> extraSystemProperties) {
        if (!extraSystemProperties.isEmpty()) {
            List<String> immutableBefore = this.jvmOptions.getAllImmutableJvmArgs();
            this.jvmOptions.systemProperties(extraSystemProperties);
            List<String> immutableAfter = this.jvmOptions.getAllImmutableJvmArgs();
            this.userDefinedImmutableJvmArgs = !immutableBefore.equals(immutableAfter);
        }
        this.baseDir = new File(layout.getGradleUserHomeDir(), "daemon");
        this.gradleUserHomeDir = layout.getGradleUserHomeDir();
        this.envVariables = new HashMap<String, String>(System.getenv());
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getGradleUserHomeDir() {
        return this.gradleUserHomeDir;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public int getPeriodicCheckInterval() {
        return this.periodicCheckInterval;
    }

    public void setPeriodicCheckInterval(int periodicCheckInterval) {
        this.periodicCheckInterval = periodicCheckInterval;
    }

    public List<String> getEffectiveJvmArgs() {
        return this.jvmOptions.getAllImmutableJvmArgs();
    }

    public List<String> getEffectiveSingleUseJvmArgs() {
        return this.jvmOptions.getAllSingleUseImmutableJvmArgs();
    }

    public JavaInfo getEffectiveJvm() {
        return this.jvm;
    }

    @Nullable
    public DaemonParameters setJvm(JavaInfo jvm) {
        this.jvm = jvm == null ? Jvm.current() : jvm;
        return this;
    }

    public void applyDefaultsFor(JavaVersion javaVersion) {
        if (this.hasJvmArgs) {
            return;
        }
        if (javaVersion.compareTo(JavaVersion.VERSION_1_8) >= 0) {
            this.jvmOptions.jvmArgs(DEFAULT_JVM_8_ARGS);
        } else {
            this.jvmOptions.jvmArgs(DEFAULT_JVM_ARGS);
        }
    }

    public Map<String, String> getSystemProperties() {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        GUtil.addToMap(systemProperties, this.jvmOptions.getMutableSystemProperties());
        return systemProperties;
    }

    public Map<String, String> getEffectiveSystemProperties() {
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        GUtil.addToMap(systemProperties, this.jvmOptions.getMutableSystemProperties());
        GUtil.addToMap(systemProperties, this.jvmOptions.getImmutableDaemonProperties());
        GUtil.addToMap(systemProperties, System.getProperties());
        return systemProperties;
    }

    public void setJvmArgs(Iterable<String> jvmArgs) {
        this.hasJvmArgs = true;
        List<String> immutableBefore = this.jvmOptions.getAllImmutableJvmArgs();
        this.jvmOptions.setAllJvmArgs(jvmArgs);
        List<String> immutableAfter = this.jvmOptions.getAllImmutableJvmArgs();
        this.userDefinedImmutableJvmArgs = this.userDefinedImmutableJvmArgs || !immutableBefore.equals(immutableAfter);
    }

    public boolean hasUserDefinedImmutableJvmArgs() {
        return this.userDefinedImmutableJvmArgs;
    }

    public void setEnvironmentVariables(Map<String, String> envVariables) {
        this.envVariables = envVariables == null ? new HashMap<String, String>(System.getenv()) : envVariables;
    }

    public void setDebug(boolean debug) {
        this.userDefinedImmutableJvmArgs = this.userDefinedImmutableJvmArgs || debug;
        this.jvmOptions.setDebug(debug);
    }

    public DaemonParameters setBaseDir(File baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    public boolean getDebug() {
        return this.jvmOptions.getDebug();
    }

    public boolean isForeground() {
        return this.foreground;
    }

    public void setForeground(boolean foreground) {
        this.foreground = foreground;
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public boolean isStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.envVariables;
    }
}

