/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.remote.internal.Connection;
import org.gradle.launcher.daemon.protocol.Command;
import org.gradle.launcher.daemon.protocol.Failure;
import org.gradle.launcher.daemon.protocol.Finished;
import org.gradle.launcher.daemon.protocol.Message;
import org.gradle.launcher.daemon.protocol.Result;
import org.gradle.launcher.daemon.protocol.Status;
import org.gradle.launcher.daemon.protocol.Success;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportStatusDispatcher {
    private static final Logger LOGGER = Logging.getLogger(ReportStatusDispatcher.class);

    public Status dispatch(Connection<Message> connection, Command statusCommand) {
        Status returnedStatus = null;
        Throwable failure = null;
        try {
            connection.dispatch(statusCommand);
            Result result = (Result)connection.receive();
            if (result instanceof Failure) {
                failure = (Throwable)((Failure)result).getValue();
            } else if (result instanceof Success) {
                returnedStatus = (Status)result.getValue();
            }
            connection.dispatch(new Finished());
        }
        catch (Throwable e) {
            failure = e;
        }
        if (failure != null) {
            LOGGER.debug(String.format("Unable to get status of %s.", connection), failure);
        }
        return returnedStatus;
    }
}

