/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.UUID;
import org.gradle.api.BuildCancelledException;
import org.gradle.api.internal.specs.ExplainingSpec;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.nativeintegration.ProcessEnvironment;
import org.gradle.internal.remote.internal.Connection;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.daemon.client.DaemonCancelForwarder;
import org.gradle.launcher.daemon.client.DaemonClientConnection;
import org.gradle.launcher.daemon.client.DaemonClientInputForwarder;
import org.gradle.launcher.daemon.client.DaemonConnector;
import org.gradle.launcher.daemon.client.DaemonDisappearedException;
import org.gradle.launcher.daemon.client.DaemonInitialConnectException;
import org.gradle.launcher.daemon.client.NoUsableDaemonFoundException;
import org.gradle.launcher.daemon.client.StaleDaemonAddressException;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.diagnostics.DaemonDiagnostics;
import org.gradle.launcher.daemon.protocol.Build;
import org.gradle.launcher.daemon.protocol.BuildEvent;
import org.gradle.launcher.daemon.protocol.BuildStarted;
import org.gradle.launcher.daemon.protocol.DaemonUnavailable;
import org.gradle.launcher.daemon.protocol.Failure;
import org.gradle.launcher.daemon.protocol.Finished;
import org.gradle.launcher.daemon.protocol.Message;
import org.gradle.launcher.daemon.protocol.OutputMessage;
import org.gradle.launcher.daemon.protocol.Result;
import org.gradle.launcher.daemon.server.api.DaemonStoppedException;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonClient
implements BuildActionExecuter<BuildActionParameters> {
    private static final Logger LOGGER = Logging.getLogger(DaemonClient.class);
    private final DaemonConnector connector;
    private final OutputEventListener outputEventListener;
    private final ExplainingSpec<DaemonContext> compatibilitySpec;
    private final InputStream buildStandardInput;
    private final ExecutorFactory executorFactory;
    private final IdGenerator<UUID> idGenerator;
    private final ProcessEnvironment processEnvironment;

    public DaemonClient(DaemonConnector connector, OutputEventListener outputEventListener, ExplainingSpec<DaemonContext> compatibilitySpec, InputStream buildStandardInput, ExecutorFactory executorFactory, IdGenerator<UUID> idGenerator, ProcessEnvironment processEnvironment) {
        this.connector = connector;
        this.outputEventListener = outputEventListener;
        this.compatibilitySpec = compatibilitySpec;
        this.buildStandardInput = buildStandardInput;
        this.executorFactory = executorFactory;
        this.idGenerator = idGenerator;
        this.processEnvironment = processEnvironment;
    }

    protected IdGenerator<UUID> getIdGenerator() {
        return this.idGenerator;
    }

    protected DaemonConnector getConnector() {
        return this.connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(BuildAction action, BuildRequestContext requestContext, BuildActionParameters parameters, ServiceRegistry contextServices) {
        UUID buildId = this.idGenerator.generateId();
        ArrayList accumulatedExceptions = Lists.newArrayList();
        LOGGER.debug("Executing build " + buildId + " in daemon client {pid=" + this.processEnvironment.maybeGetPid() + "}");
        int saneNumberOfAttempts = 100;
        for (int i = 1; i < saneNumberOfAttempts; ++i) {
            DaemonClientConnection connection = this.connector.connect(this.compatibilitySpec);
            try {
                Build build = new Build(buildId, connection.getDaemon().getToken(), action, requestContext.getClient(), requestContext.getStartTime(), parameters);
                Object object = this.executeBuild(build, connection, requestContext.getCancellationToken(), requestContext.getEventConsumer());
                return object;
            }
            catch (DaemonInitialConnectException e) {
                LOGGER.debug("{}, Trying a different daemon...", e.getMessage());
                accumulatedExceptions.add(e);
                continue;
            }
            finally {
                connection.stop();
            }
        }
        throw new NoUsableDaemonFoundException("Unable to find a usable idle daemon. I have connected to " + saneNumberOfAttempts + " different daemons but I could not use any of them to run the build. BuildActionParameters were " + parameters + ".", accumulatedExceptions);
    }

    protected Object executeBuild(Build build, DaemonClientConnection connection, BuildCancellationToken cancellationToken, BuildEventConsumer buildEventConsumer) throws DaemonInitialConnectException {
        Object result;
        try {
            LOGGER.debug("Connected to daemon {}. Dispatching request {}.", connection.getDaemon(), build);
            connection.dispatch(build);
            result = connection.receive();
        }
        catch (StaleDaemonAddressException e) {
            LOGGER.debug("Connected to a stale daemon address.", e);
            throw new DaemonInitialConnectException("Connected to a stale daemon address.", e);
        }
        if (result == null) {
            throw new DaemonInitialConnectException("The first result from the daemon was empty. Most likely the process died immediately after connection.");
        }
        LOGGER.debug("Received result {} from daemon {} (build should be starting).", result, connection.getDaemon());
        DaemonDiagnostics diagnostics = null;
        if (result instanceof BuildStarted) {
            diagnostics = ((BuildStarted)result).getDiagnostics();
            result = this.monitorBuild(build, diagnostics, connection, cancellationToken, buildEventConsumer);
        }
        LOGGER.debug("Received result {} from daemon {} (build should be done).", result, connection.getDaemon());
        connection.dispatch(new Finished());
        if (result instanceof Failure) {
            Throwable failure = (Throwable)((Failure)result).getValue();
            if (failure instanceof DaemonStoppedException && cancellationToken.isCancellationRequested()) {
                LOGGER.error("Daemon was stopped to handle build cancel request.");
                throw new BuildCancelledException();
            }
            throw UncheckedException.throwAsUncheckedException(failure);
        }
        if (result instanceof DaemonUnavailable) {
            throw new DaemonInitialConnectException("The daemon we connected to was unavailable: " + ((DaemonUnavailable)result).getReason());
        }
        if (result instanceof Result) {
            return ((Result)result).getValue();
        }
        throw this.invalidResponse(result, build, diagnostics);
    }

    private Object monitorBuild(Build build, DaemonDiagnostics diagnostics, Connection<Message> connection, BuildCancellationToken cancellationToken, BuildEventConsumer buildEventConsumer) {
        Result result;
        Message object;
        DaemonClientInputForwarder inputForwarder = new DaemonClientInputForwarder(this.buildStandardInput, connection, this.executorFactory);
        DaemonCancelForwarder cancelForwarder = new DaemonCancelForwarder(connection, cancellationToken);
        try {
            cancelForwarder.start();
            inputForwarder.start();
            int objectsReceived = 0;
            while (true) {
                object = (Message)connection.receive();
                ++objectsReceived;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Received object #{}, type: {}", objectsReceived++, object == null ? null : object.getClass().getName());
                }
                if (object != null) break block8;
                result = this.handleDaemonDisappearance(build, diagnostics);
                break;
            }
        }
        catch (Throwable throwable) {
            CompositeStoppable.stoppable(cancelForwarder, inputForwarder).stop();
            throw throwable;
        }
        {
            block9: {
                block8: {
                    CompositeStoppable.stoppable(cancelForwarder, inputForwarder).stop();
                    return result;
                }
                if (object instanceof OutputMessage) {
                    this.outputEventListener.onOutput(((OutputMessage)object).getEvent());
                    break block9;
                }
                if (object instanceof BuildEvent) {
                    buildEventConsumer.dispatch(((BuildEvent)object).getPayload());
                    break block9;
                }
                Message message = object;
                CompositeStoppable.stoppable(cancelForwarder, inputForwarder).stop();
                return message;
            }
            continue;
        }
    }

    private Result handleDaemonDisappearance(Build build, DaemonDiagnostics diagnostics) {
        LOGGER.error("The message received from the daemon indicates that the daemon has disappeared.\nBuild request sent: {}\nAttempting to read last messages from the daemon log...", build);
        LOGGER.error(diagnostics.describe());
        throw new DaemonDisappearedException();
    }

    private IllegalStateException invalidResponse(Object response, Build command, DaemonDiagnostics diagnostics) {
        String diagnosticsMessage = diagnostics == null ? "No diagnostics available." : diagnostics.describe();
        return new IllegalStateException(String.format("Received invalid response from the daemon: '%s' is a result of a type we don't have a strategy to handle. Earlier, '%s' request was sent to the daemon. Diagnostics:\n%s", response, command, diagnosticsMessage));
    }
}

