/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.internal;

import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.language.ComponentDependencies;
import org.gradle.language.ComponentWithDependencies;
import org.gradle.language.internal.DefaultComponentDependencies;
import org.gradle.language.nativeplatform.ComponentWithObjectFiles;
import org.gradle.language.nativeplatform.internal.ComponentWithNames;
import org.gradle.language.nativeplatform.internal.Names;

public abstract class DefaultNativeBinary
implements ComponentWithNames,
ComponentWithObjectFiles,
ComponentWithDependencies {
    private final String name;
    private final Names names;
    private final DirectoryProperty objectsDir;
    private final DefaultComponentDependencies dependencies;

    public DefaultNativeBinary(String name, ObjectFactory objectFactory, ProjectLayout projectLayout, Configuration componentImplementation) {
        this.name = name;
        this.names = Names.of(name);
        this.objectsDir = projectLayout.directoryProperty();
        this.dependencies = objectFactory.newInstance(DefaultComponentDependencies.class, name + "Implementation");
        this.dependencies.getImplementationDependencies().extendsFrom(componentImplementation);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Names getNames() {
        return this.names;
    }

    public DirectoryProperty getObjectsDir() {
        return this.objectsDir;
    }

    @Override
    public FileCollection getObjects() {
        return this.objectsDir.getAsFileTree().matching(new PatternSet().include("**/*.obj", "**/*.o"));
    }

    @Override
    public ComponentDependencies getDependencies() {
        return this.dependencies;
    }

    public void dependencies(Action<? super ComponentDependencies> action) {
        action.execute(this.getDependencies());
    }

    public Configuration getImplementationDependencies() {
        return this.dependencies.getImplementationDependencies();
    }
}

