/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.provider.LockableSetProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.language.LibraryDependencies;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppLibrary;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.internal.DefaultCppComponent;
import org.gradle.language.cpp.internal.DefaultCppSharedLibrary;
import org.gradle.language.cpp.internal.DefaultCppStaticLibrary;
import org.gradle.language.cpp.internal.MainLibraryVariant;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.DefaultLibraryDependencies;
import org.gradle.language.nativeplatform.internal.PublicationAwareComponent;
import org.gradle.nativeplatform.Linkage;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

public class DefaultCppLibrary
extends DefaultCppComponent
implements CppLibrary,
PublicationAwareComponent {
    private final ObjectFactory objectFactory;
    private final ConfigurableFileCollection publicHeaders;
    private final FileCollection publicHeadersWithConvention;
    private final LockableSetProperty<Linkage> linkage;
    private final Property<CppBinary> developmentBinary;
    private final Configuration apiElements;
    private final MainLibraryVariant mainVariant;
    private final DefaultLibraryDependencies dependencies;

    @Inject
    public DefaultCppLibrary(String name, ObjectFactory objectFactory, FileOperations fileOperations, ConfigurationContainer configurations) {
        super(name, fileOperations, objectFactory);
        this.objectFactory = objectFactory;
        this.developmentBinary = objectFactory.property(CppBinary.class);
        this.publicHeaders = fileOperations.files(new Object[0]);
        this.publicHeadersWithConvention = this.createDirView(this.publicHeaders, "src/" + name + "/public");
        this.linkage = new LockableSetProperty<Linkage>(objectFactory.setProperty(Linkage.class));
        this.linkage.add(Linkage.SHARED);
        this.dependencies = objectFactory.newInstance(DefaultLibraryDependencies.class, this.getNames().withSuffix("implementation"), this.getNames().withSuffix("api"));
        Usage apiUsage = objectFactory.named(Usage.class, "cplusplus-api");
        this.apiElements = (Configuration)configurations.create(this.getNames().withSuffix("cppApiElements"));
        this.apiElements.extendsFrom(this.dependencies.getApiDependencies());
        this.apiElements.setCanBeResolved(false);
        this.apiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, apiUsage);
        this.mainVariant = new MainLibraryVariant("api", apiUsage, this.apiElements);
    }

    public DefaultCppSharedLibrary addSharedLibrary(NativeVariantIdentity identity, CppPlatform targetPlatform, NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider) {
        DefaultCppSharedLibrary result = this.objectFactory.newInstance(DefaultCppSharedLibrary.class, this.getName() + StringUtils.capitalize((String)identity.getName()), this.getBaseName(), this.getCppSource(), this.getAllHeaderDirs(), this.getImplementationDependencies(), targetPlatform, toolChain, platformToolProvider, identity);
        ((DefaultBinaryCollection)this.getBinaries()).add(result);
        return result;
    }

    public DefaultCppStaticLibrary addStaticLibrary(NativeVariantIdentity identity, CppPlatform targetPlatform, NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider) {
        DefaultCppStaticLibrary result = this.objectFactory.newInstance(DefaultCppStaticLibrary.class, this.getName() + StringUtils.capitalize((String)identity.getName()), this.getBaseName(), this.getCppSource(), this.getAllHeaderDirs(), this.getImplementationDependencies(), targetPlatform, toolChain, platformToolProvider, identity);
        ((DefaultBinaryCollection)this.getBinaries()).add(result);
        return result;
    }

    @Override
    public DisplayName getDisplayName() {
        return Describables.withTypeAndName("C++ library", this.getName());
    }

    @Override
    public Configuration getImplementationDependencies() {
        return this.dependencies.getImplementationDependencies();
    }

    @Override
    public Configuration getApiDependencies() {
        return this.dependencies.getApiDependencies();
    }

    @Override
    public LibraryDependencies getDependencies() {
        return this.dependencies;
    }

    public void dependencies(Action<? super LibraryDependencies> action) {
        action.execute(this.dependencies);
    }

    public Configuration getApiElements() {
        return this.apiElements;
    }

    @Override
    public MainLibraryVariant getMainPublication() {
        return this.mainVariant;
    }

    @Override
    public ConfigurableFileCollection getPublicHeaders() {
        return this.publicHeaders;
    }

    @Override
    public void publicHeaders(Action<? super ConfigurableFileCollection> action) {
        action.execute(this.publicHeaders);
    }

    @Override
    public FileCollection getPublicHeaderDirs() {
        return this.publicHeadersWithConvention;
    }

    @Override
    public FileTree getPublicHeaderFiles() {
        PatternSet patterns = new PatternSet();
        patterns.include("**/*.h");
        patterns.include("**/*.hpp");
        return this.publicHeadersWithConvention.getAsFileTree().matching(patterns);
    }

    @Override
    public FileCollection getAllHeaderDirs() {
        return this.publicHeadersWithConvention.plus(super.getAllHeaderDirs());
    }

    public Property<CppBinary> getDevelopmentBinary() {
        return this.developmentBinary;
    }

    public LockableSetProperty<Linkage> getLinkage() {
        return this.linkage;
    }
}

