/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.language.ComponentDependencies;
import org.gradle.language.cpp.CppApplication;
import org.gradle.language.cpp.CppExecutable;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.internal.DefaultCppComponent;
import org.gradle.language.cpp.internal.DefaultCppExecutable;
import org.gradle.language.cpp.internal.MainExecutableVariant;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.DefaultComponentDependencies;
import org.gradle.language.nativeplatform.internal.PublicationAwareComponent;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

public class DefaultCppApplication
extends DefaultCppComponent
implements CppApplication,
PublicationAwareComponent {
    private final ObjectFactory objectFactory;
    private final Property<CppExecutable> developmentBinary;
    private final MainExecutableVariant mainVariant = new MainExecutableVariant();
    private final DefaultComponentDependencies dependencies;

    @Inject
    public DefaultCppApplication(String name, ObjectFactory objectFactory, FileOperations fileOperations) {
        super(name, fileOperations, objectFactory);
        this.objectFactory = objectFactory;
        this.developmentBinary = objectFactory.property(CppExecutable.class);
        this.dependencies = objectFactory.newInstance(DefaultComponentDependencies.class, this.getNames().withSuffix("implementation"));
    }

    public DefaultCppExecutable addExecutable(NativeVariantIdentity identity, CppPlatform targetPlatform, NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider) {
        DefaultCppExecutable result = this.objectFactory.newInstance(DefaultCppExecutable.class, this.getName() + StringUtils.capitalize((String)identity.getName()), this.getBaseName(), this.getCppSource(), this.getPrivateHeaderDirs(), this.getImplementationDependencies(), targetPlatform, toolChain, platformToolProvider, identity);
        ((DefaultBinaryCollection)this.getBinaries()).add(result);
        return result;
    }

    @Override
    public DisplayName getDisplayName() {
        return Describables.withTypeAndName("C++ application", this.getName());
    }

    @Override
    public Configuration getImplementationDependencies() {
        return this.dependencies.getImplementationDependencies();
    }

    @Override
    public ComponentDependencies getDependencies() {
        return this.dependencies;
    }

    public void dependencies(Action<? super ComponentDependencies> action) {
        action.execute(this.dependencies);
    }

    @Override
    public MainExecutableVariant getMainPublication() {
        return this.mainVariant;
    }

    public Property<CppExecutable> getDevelopmentBinary() {
        return this.developmentBinary;
    }
}

