/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.xml.XmlValidation;

public class SimpleMarkupWriter
extends Writer {
    private static final String LINE_SEPARATOR = SystemProperties.getInstance().getLineSeparator();
    private final Writer output;
    private final Deque<String> elements = new ArrayDeque<String>();
    private Context context = Context.Outside;
    private int squareBrackets;
    private final String indent;

    protected SimpleMarkupWriter(Writer writer, String indent) throws IOException {
        this.indent = indent;
        this.output = writer;
    }

    public void write(char[] chars, int offset, int length) throws IOException {
        this.characters(chars, offset, length);
    }

    public void flush() throws IOException {
        this.output.flush();
    }

    public void close() throws IOException {
    }

    public SimpleMarkupWriter characters(char[] characters) throws IOException {
        this.characters(characters, 0, characters.length);
        return this;
    }

    public SimpleMarkupWriter characters(char[] characters, int start, int count) throws IOException {
        if (this.context == Context.CData) {
            this.writeCDATA(characters, start, count);
        } else {
            this.maybeStartText();
            this.writeXmlEncoded(characters, start, count);
        }
        return this;
    }

    public SimpleMarkupWriter characters(CharSequence characters) throws IOException {
        if (this.context == Context.CData) {
            this.writeCDATA(characters);
        } else {
            this.maybeStartText();
            this.writeXmlEncoded(characters);
        }
        return this;
    }

    private void maybeStartText() throws IOException {
        if (this.context == Context.Outside) {
            throw new IllegalStateException("Cannot write text, as there are no started elements.");
        }
        if (this.context == Context.StartTag) {
            this.writeRaw(">");
        }
        this.context = Context.Text;
    }

    private void maybeFinishStartTag() throws IOException {
        if (this.context == Context.StartTag) {
            this.writeRaw(">");
            this.context = Context.ElementContent;
        }
    }

    public SimpleMarkupWriter startElement(String name) throws IOException {
        if (!XmlValidation.isValidXmlName(name)) {
            throw new IllegalArgumentException(String.format("Invalid element name: '%s'", name));
        }
        if (this.context == Context.CData) {
            throw new IllegalStateException("Cannot start element, as current CDATA node has not been closed.");
        }
        this.maybeFinishStartTag();
        if (this.indent != null) {
            this.writeRaw(LINE_SEPARATOR);
            for (int i = 0; i < this.elements.size(); ++i) {
                this.writeRaw(this.indent);
            }
        }
        this.context = Context.StartTag;
        this.elements.add(name);
        this.writeRaw("<");
        this.writeRaw(name);
        return this;
    }

    public SimpleMarkupWriter endElement() throws IOException {
        if (this.context == Context.Outside) {
            throw new IllegalStateException("Cannot end element, as there are no started elements.");
        }
        if (this.context == Context.CData) {
            throw new IllegalStateException("Cannot end element, as current CDATA node has not been closed.");
        }
        if (this.context == Context.StartTag) {
            this.writeRaw("/>");
            this.elements.removeLast();
        } else {
            if (this.context != Context.Text && this.indent != null) {
                this.writeRaw(LINE_SEPARATOR);
                for (int i = 1; i < this.elements.size(); ++i) {
                    this.writeRaw(this.indent);
                }
            }
            this.writeRaw("</");
            this.writeRaw(this.elements.removeLast());
            this.writeRaw(">");
        }
        if (this.elements.isEmpty()) {
            if (this.indent != null) {
                this.writeRaw(LINE_SEPARATOR);
            }
            this.output.flush();
            this.context = Context.Outside;
        } else {
            this.context = Context.ElementContent;
        }
        return this;
    }

    private void writeCDATA(char[] cdata, int offset, int count) throws IOException {
        int end = offset + count;
        for (int i = offset; i < end; ++i) {
            this.writeCDATA(cdata[i]);
        }
    }

    private void writeCDATA(CharSequence cdata) throws IOException {
        int len = cdata.length();
        for (int i = 0; i < len; ++i) {
            this.writeCDATA(cdata.charAt(i));
        }
    }

    private void writeCDATA(char ch) throws IOException {
        if (this.needsCDATAEscaping(ch)) {
            this.writeRaw("]]><![CDATA[>");
        } else if (!XmlValidation.isLegalCharacter(ch)) {
            this.writeRaw('?');
        } else if (XmlValidation.isRestrictedCharacter(ch)) {
            this.writeRaw("]]>");
            this.writeCharacterReference(ch);
            this.writeRaw("<![CDATA[");
        } else {
            this.writeRaw(ch);
        }
    }

    private void writeCharacterReference(char ch) throws IOException {
        this.writeRaw("&#x");
        this.writeRaw(Integer.toHexString(ch));
        this.writeRaw(";");
    }

    private boolean needsCDATAEscaping(char ch) {
        switch (ch) {
            case ']': {
                ++this.squareBrackets;
                return false;
            }
            case '>': {
                if (this.squareBrackets >= 2) {
                    this.squareBrackets = 0;
                    return true;
                }
                return false;
            }
        }
        this.squareBrackets = 0;
        return false;
    }

    public SimpleMarkupWriter startCDATA() throws IOException {
        if (this.context == Context.CData) {
            throw new IllegalStateException("Cannot start CDATA node, as current CDATA node has not been closed.");
        }
        this.maybeFinishStartTag();
        this.writeRaw("<![CDATA[");
        this.context = Context.CData;
        this.squareBrackets = 0;
        return this;
    }

    public SimpleMarkupWriter endCDATA() throws IOException {
        if (this.context != Context.CData) {
            throw new IllegalStateException("Cannot end CDATA node, as not currently in a CDATA node.");
        }
        this.writeRaw("]]>");
        this.context = Context.Text;
        return this;
    }

    public SimpleMarkupWriter attribute(String name, String value) throws IOException {
        if (!XmlValidation.isValidXmlName(name)) {
            throw new IllegalArgumentException(String.format("Invalid attribute name: '%s'", name));
        }
        if (this.context != Context.StartTag) {
            throw new IllegalStateException("Cannot write attribute [" + name + ":" + value + "]. You should write start element first.");
        }
        this.writeRaw(" ");
        this.writeRaw(name);
        this.writeRaw("=\"");
        this.writeXmlAttributeEncoded(value);
        this.writeRaw("\"");
        return this;
    }

    private void writeRaw(char c) throws IOException {
        this.output.write(c);
    }

    protected void writeRaw(String message) throws IOException {
        this.output.write(message);
    }

    private void writeXmlEncoded(char[] message, int offset, int count) throws IOException {
        int end = offset + count;
        for (int i = offset; i < end; ++i) {
            this.writeXmlEncoded(message[i]);
        }
    }

    private void writeXmlAttributeEncoded(CharSequence message) throws IOException {
        assert (message != null);
        int len = message.length();
        for (int i = 0; i < len; ++i) {
            this.writeXmlAttributeEncoded(message.charAt(i));
        }
    }

    private void writeXmlAttributeEncoded(char ch) throws IOException {
        if (ch == '\t') {
            this.writeRaw("&#9;");
        } else if (ch == '\n') {
            this.writeRaw("&#10;");
        } else if (ch == '\r') {
            this.writeRaw("&#13;");
        } else {
            this.writeXmlEncoded(ch);
        }
    }

    private void writeXmlEncoded(CharSequence message) throws IOException {
        assert (message != null);
        int len = message.length();
        for (int i = 0; i < len; ++i) {
            this.writeXmlEncoded(message.charAt(i));
        }
    }

    private void writeXmlEncoded(char ch) throws IOException {
        if (ch == '<') {
            this.writeRaw("&lt;");
        } else if (ch == '>') {
            this.writeRaw("&gt;");
        } else if (ch == '&') {
            this.writeRaw("&amp;");
        } else if (ch == '\"') {
            this.writeRaw("&quot;");
        } else if (!XmlValidation.isLegalCharacter(ch)) {
            this.writeRaw('?');
        } else if (XmlValidation.isRestrictedCharacter(ch)) {
            this.writeCharacterReference(ch);
        } else {
            this.writeRaw(ch);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Context {
        Outside,
        Text,
        CData,
        StartTag,
        ElementContent;

    }
}

