/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.io.ClassLoaderObjectInputStream;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSerializer<T>
extends AbstractSerializer<T> {
    private ClassLoader classLoader;

    public DefaultSerializer() {
        this.classLoader = this.getClass().getClassLoader();
    }

    public DefaultSerializer(ClassLoader classLoader) {
        this.classLoader = classLoader != null ? classLoader : this.getClass().getClassLoader();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public T read(Decoder decoder) throws Exception {
        try {
            return (T)new ClassLoaderObjectInputStream(decoder.getInputStream(), this.classLoader).readObject();
        }
        catch (StreamCorruptedException e) {
            return null;
        }
    }

    @Override
    public void write(Encoder encoder, T value) throws IOException {
        ObjectOutputStream objectStr = new ObjectOutputStream(encoder.getOutputStream());
        objectStr.writeObject(value);
        objectStr.flush();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        DefaultSerializer rhs = (DefaultSerializer)obj;
        return Objects.equal((Object)this.classLoader, (Object)rhs.classLoader);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.classLoader});
    }
}

