/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.IOException;
import java.net.ProxySelector;
import java.util.Collection;
import java.util.Collections;
import javax.net.ssl.HostnameVerifier;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.credentials.PasswordCredentials;
import org.gradle.api.specs.Spec;
import org.gradle.authentication.Authentication;
import org.gradle.authentication.http.BasicAuthentication;
import org.gradle.authentication.http.DigestAuthentication;
import org.gradle.internal.Cast;
import org.gradle.internal.authentication.AllSchemesAuthentication;
import org.gradle.internal.authentication.AuthenticationInternal;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.org.apache.http.HttpException;
import org.gradle.internal.impldep.org.apache.http.HttpHost;
import org.gradle.internal.impldep.org.apache.http.HttpRequest;
import org.gradle.internal.impldep.org.apache.http.HttpRequestInterceptor;
import org.gradle.internal.impldep.org.apache.http.auth.AuthScheme;
import org.gradle.internal.impldep.org.apache.http.auth.AuthScope;
import org.gradle.internal.impldep.org.apache.http.auth.AuthState;
import org.gradle.internal.impldep.org.apache.http.auth.NTCredentials;
import org.gradle.internal.impldep.org.apache.http.auth.UsernamePasswordCredentials;
import org.gradle.internal.impldep.org.apache.http.client.CredentialsProvider;
import org.gradle.internal.impldep.org.apache.http.client.RedirectStrategy;
import org.gradle.internal.impldep.org.apache.http.client.config.RequestConfig;
import org.gradle.internal.impldep.org.apache.http.config.Lookup;
import org.gradle.internal.impldep.org.apache.http.config.RegistryBuilder;
import org.gradle.internal.impldep.org.apache.http.config.SocketConfig;
import org.gradle.internal.impldep.org.apache.http.conn.routing.HttpRoutePlanner;
import org.gradle.internal.impldep.org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.gradle.internal.impldep.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.gradle.internal.impldep.org.apache.http.conn.util.PublicSuffixMatcher;
import org.gradle.internal.impldep.org.apache.http.conn.util.PublicSuffixMatcherLoader;
import org.gradle.internal.impldep.org.apache.http.impl.auth.BasicScheme;
import org.gradle.internal.impldep.org.apache.http.impl.auth.BasicSchemeFactory;
import org.gradle.internal.impldep.org.apache.http.impl.auth.DigestSchemeFactory;
import org.gradle.internal.impldep.org.apache.http.impl.auth.KerberosSchemeFactory;
import org.gradle.internal.impldep.org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.gradle.internal.impldep.org.apache.http.impl.client.HttpClientBuilder;
import org.gradle.internal.impldep.org.apache.http.impl.client.SystemDefaultCredentialsProvider;
import org.gradle.internal.impldep.org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.gradle.internal.impldep.org.apache.http.impl.cookie.DefaultCookieSpecProvider;
import org.gradle.internal.impldep.org.apache.http.impl.cookie.IgnoreSpecProvider;
import org.gradle.internal.impldep.org.apache.http.impl.cookie.NetscapeDraftSpecProvider;
import org.gradle.internal.impldep.org.apache.http.impl.cookie.RFC6265CookieSpecProvider;
import org.gradle.internal.impldep.org.apache.http.protocol.HttpContext;
import org.gradle.internal.resource.UriTextResource;
import org.gradle.internal.resource.transport.http.AlwaysRedirectRedirectStrategy;
import org.gradle.internal.resource.transport.http.HttpProxySettings;
import org.gradle.internal.resource.transport.http.HttpSettings;
import org.gradle.internal.resource.transport.http.HttpTimeoutSettings;
import org.gradle.internal.resource.transport.http.SslContextFactory;
import org.gradle.internal.resource.transport.http.ntlm.NTLMCredentials;
import org.gradle.internal.resource.transport.http.ntlm.NTLMSchemeFactory;
import org.gradle.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientConfigurer.class);
    private static final int MAX_HTTP_CONNECTIONS = 20;
    private final HttpSettings httpSettings;

    public HttpClientConfigurer(HttpSettings httpSettings) {
        this.httpSettings = httpSettings;
    }

    public void configure(HttpClientBuilder builder) {
        SystemDefaultCredentialsProvider credentialsProvider = new SystemDefaultCredentialsProvider();
        this.configureSslSocketConnectionFactory(builder, this.httpSettings.getSslContextFactory(), this.httpSettings.getHostnameVerifier());
        this.configureAuthSchemeRegistry(builder);
        this.configureCredentials(builder, (CredentialsProvider)credentialsProvider, this.httpSettings.getAuthenticationSettings());
        this.configureProxy(builder, (CredentialsProvider)credentialsProvider, this.httpSettings);
        this.configureUserAgent(builder);
        this.configureCookieSpecRegistry(builder);
        this.configureRequestConfig(builder);
        this.configureSocketConfig(builder);
        this.configureRedirectStrategy(builder);
        builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        builder.setMaxConnTotal(20);
        builder.setMaxConnPerRoute(20);
    }

    private void configureSslSocketConnectionFactory(HttpClientBuilder builder, SslContextFactory sslContextFactory, HostnameVerifier hostnameVerifier) {
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContextFactory.createSslContext(), hostnameVerifier));
    }

    private void configureAuthSchemeRegistry(HttpClientBuilder builder) {
        builder.setDefaultAuthSchemeRegistry((Lookup)RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory()).register("Digest", (Object)new DigestSchemeFactory()).register("NTLM", (Object)new NTLMSchemeFactory()).register("Negotiate", (Object)new SPNegoSchemeFactory()).register("Kerberos", (Object)new KerberosSchemeFactory()).build());
    }

    private void configureCredentials(HttpClientBuilder builder, CredentialsProvider credentialsProvider, Collection<Authentication> authentications) {
        if (authentications.size() > 0) {
            this.useCredentials(credentialsProvider, AuthScope.ANY_HOST, -1, authentications);
            builder.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuth((AuthScheme)new BasicScheme(), this.isPreemptiveEnabled(authentications)));
        }
    }

    private void configureProxy(HttpClientBuilder builder, CredentialsProvider credentialsProvider, HttpSettings httpSettings) {
        HttpProxySettings.HttpProxy httpProxy = httpSettings.getProxySettings().getProxy();
        HttpProxySettings.HttpProxy httpsProxy = httpSettings.getSecureProxySettings().getProxy();
        for (HttpProxySettings.HttpProxy proxy : Lists.newArrayList((Object[])new HttpProxySettings.HttpProxy[]{httpProxy, httpsProxy})) {
            if (proxy == null || proxy.credentials == null) continue;
            this.useCredentials(credentialsProvider, proxy.host, proxy.port, Collections.singleton(new AllSchemesAuthentication(proxy.credentials)));
        }
        builder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault()));
    }

    private void useCredentials(CredentialsProvider credentialsProvider, String host, int port, Collection<? extends Authentication> authentications) {
        for (Authentication authentication : authentications) {
            UsernamePasswordCredentials httpCredentials;
            String scheme = this.getAuthScheme(authentication);
            PasswordCredentials credentials = this.getPasswordCredentials(authentication);
            if (authentication instanceof AllSchemesAuthentication) {
                NTLMCredentials ntlmCredentials = new NTLMCredentials(credentials);
                httpCredentials = new NTCredentials(ntlmCredentials.getUsername(), ntlmCredentials.getPassword(), ntlmCredentials.getWorkstation(), ntlmCredentials.getDomain());
                credentialsProvider.setCredentials(new AuthScope(host, port, AuthScope.ANY_REALM, "NTLM"), (org.gradle.internal.impldep.org.apache.http.auth.Credentials)httpCredentials);
                LOGGER.debug("Using {} and {} for authenticating against '{}:{}' using {}", new Object[]{credentials, ntlmCredentials, host, port, "NTLM"});
            }
            httpCredentials = new UsernamePasswordCredentials(credentials.getUsername(), credentials.getPassword());
            credentialsProvider.setCredentials(new AuthScope(host, port, AuthScope.ANY_REALM, scheme), (org.gradle.internal.impldep.org.apache.http.auth.Credentials)httpCredentials);
            LOGGER.debug("Using {} for authenticating against '{}:{}' using {}", new Object[]{credentials, host, port, scheme});
        }
    }

    private boolean isPreemptiveEnabled(Collection<Authentication> authentications) {
        return CollectionUtils.any(authentications, new Spec<Authentication>(){

            @Override
            public boolean isSatisfiedBy(Authentication element) {
                return element instanceof BasicAuthentication;
            }
        });
    }

    public void configureUserAgent(HttpClientBuilder builder) {
        builder.setUserAgent(UriTextResource.getUserAgentString());
    }

    private void configureCookieSpecRegistry(HttpClientBuilder builder) {
        PublicSuffixMatcher publicSuffixMatcher = PublicSuffixMatcherLoader.getDefault();
        builder.setPublicSuffixMatcher(publicSuffixMatcher);
        DefaultCookieSpecProvider defaultProvider = new DefaultCookieSpecProvider(DefaultCookieSpecProvider.CompatibilityLevel.DEFAULT, publicSuffixMatcher, new String[]{"EEE, dd-MMM-yy HH:mm:ss z", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy", "EEE, dd MMM yyyy HH:mm:ss zzz"}, false);
        RFC6265CookieSpecProvider laxStandardProvider = new RFC6265CookieSpecProvider(RFC6265CookieSpecProvider.CompatibilityLevel.RELAXED, publicSuffixMatcher);
        RFC6265CookieSpecProvider strictStandardProvider = new RFC6265CookieSpecProvider(RFC6265CookieSpecProvider.CompatibilityLevel.STRICT, publicSuffixMatcher);
        builder.setDefaultCookieSpecRegistry((Lookup)RegistryBuilder.create().register("default", (Object)defaultProvider).register("best-match", (Object)defaultProvider).register("compatibility", (Object)defaultProvider).register("standard", (Object)laxStandardProvider).register("standard-strict", (Object)strictStandardProvider).register("netscape", (Object)new NetscapeDraftSpecProvider()).register("ignoreCookies", (Object)new IgnoreSpecProvider()).build());
    }

    private void configureRequestConfig(HttpClientBuilder builder) {
        HttpTimeoutSettings timeoutSettings = this.httpSettings.getTimeoutSettings();
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeoutSettings.getConnectionTimeoutMs()).setSocketTimeout(timeoutSettings.getSocketTimeoutMs()).build();
        builder.setDefaultRequestConfig(config);
    }

    private void configureSocketConfig(HttpClientBuilder builder) {
        HttpTimeoutSettings timeoutSettings = this.httpSettings.getTimeoutSettings();
        builder.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(timeoutSettings.getSocketTimeoutMs()).build());
    }

    private PasswordCredentials getPasswordCredentials(Authentication authentication) {
        Credentials credentials = ((AuthenticationInternal)authentication).getCredentials();
        if (!(credentials instanceof PasswordCredentials)) {
            throw new IllegalArgumentException(String.format("Credentials must be an instance of: %s", PasswordCredentials.class.getCanonicalName()));
        }
        return (PasswordCredentials)Cast.uncheckedCast(credentials);
    }

    private void configureRedirectStrategy(HttpClientBuilder builder) {
        if (this.httpSettings.isFollowRedirects()) {
            builder.setRedirectStrategy((RedirectStrategy)new AlwaysRedirectRedirectStrategy());
        } else {
            builder.disableRedirectHandling();
        }
    }

    private String getAuthScheme(Authentication authentication) {
        if (authentication instanceof BasicAuthentication) {
            return "Basic";
        }
        if (authentication instanceof DigestAuthentication) {
            return "Digest";
        }
        if (authentication instanceof AllSchemesAuthentication) {
            return AuthScope.ANY_SCHEME;
        }
        throw new IllegalArgumentException(String.format("Authentication scheme of '%s' is not supported.", authentication.getClass().getSimpleName()));
    }

    static class PreemptiveAuth
    implements HttpRequestInterceptor {
        private final AuthScheme authScheme;
        private final boolean alwaysSendAuth;

        PreemptiveAuth(AuthScheme authScheme, boolean alwaysSendAuth) {
            this.authScheme = authScheme;
            this.alwaysSendAuth = alwaysSendAuth;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() != null || authState.hasAuthOptions()) {
                return;
            }
            String requestMethod = request.getRequestLine().getMethod();
            if (this.alwaysSendAuth || requestMethod.equals("PUT") || requestMethod.equals("POST")) {
                HttpHost targetHost;
                CredentialsProvider credentialsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                org.gradle.internal.impldep.org.apache.http.auth.Credentials credentials = credentialsProvider.getCredentials(new AuthScope((targetHost = (HttpHost)context.getAttribute("http.target_host")).getHostName(), targetHost.getPort()));
                if (credentials == null) {
                    throw new HttpException("No credentials for preemptive authentication");
                }
                authState.update(this.authScheme, credentials);
            }
        }
    }
}

