/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.trace;

import java.util.Collections;
import java.util.Map;
import org.gradle.api.internal.artifacts.configurations.ResolveConfigurationDependenciesBuildOperationType;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.trace.SerializedOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SerializedOperationFinish
implements SerializedOperation {
    final long id;
    final long endTime;
    final Object result;
    final String resultClassName;
    final String failureMsg;

    SerializedOperationFinish(BuildOperationDescriptor descriptor, OperationFinishEvent finishEvent) {
        this.id = descriptor.getId().getId();
        this.endTime = finishEvent.getEndTime();
        this.result = this.transform(finishEvent.getResult());
        this.resultClassName = this.result == null ? null : finishEvent.getResult().getClass().getName();
        this.failureMsg = finishEvent.getFailure() == null ? null : finishEvent.getFailure().toString();
    }

    private Object transform(Object result) {
        if (result instanceof ResolveConfigurationDependenciesBuildOperationType.Result) {
            ResolveConfigurationDependenciesBuildOperationType.Result cast = (ResolveConfigurationDependenciesBuildOperationType.Result)result;
            return Collections.singletonMap("resolvedDependenciesCount", cast.getRootComponent().getDependencies().size());
        }
        return result;
    }

    SerializedOperationFinish(Map<String, ?> map) {
        this.id = ((Integer)map.get("id")).longValue();
        this.endTime = (Long)map.get("endTime");
        this.result = map.get("result");
        this.resultClassName = (String)map.get("resultClassName");
        this.failureMsg = (String)map.get("failure");
    }

    @Override
    public Map<String, ?> toMap() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)"id", (Object)this.id);
        if (this.result != null) {
            map.put((Object)"result", this.result);
            map.put((Object)"resultClassName", (Object)this.resultClassName);
        }
        if (this.failureMsg != null) {
            map.put((Object)"failure", (Object)this.failureMsg);
        }
        map.put((Object)"endTime", (Object)this.endTime);
        return map.build();
    }
}

