/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;

public class DefaultBuildOperationListenerManager
implements BuildOperationListenerManager {
    private List<ProgressShieldingBuildOperationListener> listeners = Collections.emptyList();
    private final Lock listenersLock = new ReentrantLock();
    private final BuildOperationListener broadcaster = new BuildOperationListener(){

        public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
            List listeners = DefaultBuildOperationListenerManager.this.listeners;
            for (int i = 0; i < listeners.size(); ++i) {
                ((BuildOperationListener)listeners.get(i)).started(buildOperation, startEvent);
            }
        }

        public void progress(OperationIdentifier operationIdentifier, OperationProgressEvent progressEvent) {
            List listeners = DefaultBuildOperationListenerManager.this.listeners;
            for (int i = 0; i < listeners.size(); ++i) {
                ((BuildOperationListener)listeners.get(i)).progress(operationIdentifier, progressEvent);
            }
        }

        public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
            List listeners = DefaultBuildOperationListenerManager.this.listeners;
            for (int i = listeners.size() - 1; i >= 0; --i) {
                ((BuildOperationListener)listeners.get(i)).finished(buildOperation, finishEvent);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(BuildOperationListener listener) {
        this.listenersLock.lock();
        try {
            ArrayList<ProgressShieldingBuildOperationListener> listeners = new ArrayList<ProgressShieldingBuildOperationListener>(this.listeners);
            listeners.add(new ProgressShieldingBuildOperationListener(listener));
            this.listeners = listeners;
            Object var4_3 = null;
            this.listenersLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.listenersLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(BuildOperationListener listener) {
        this.listenersLock.lock();
        try {
            ArrayList<ProgressShieldingBuildOperationListener> listeners = new ArrayList<ProgressShieldingBuildOperationListener>(this.listeners);
            ListIterator listIterator = listeners.listIterator();
            while (listIterator.hasNext()) {
                if (!((ProgressShieldingBuildOperationListener)listIterator.next()).delegate.equals(listener)) continue;
                listIterator.remove();
            }
            this.listeners = listeners;
            Object var5_4 = null;
            this.listenersLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.listenersLock.unlock();
            throw throwable;
        }
    }

    public BuildOperationListener getBroadcaster() {
        return this.broadcaster;
    }

    private static class ProgressShieldingBuildOperationListener
    implements BuildOperationListener {
        private final Set<OperationIdentifier> active = Sets.newConcurrentHashSet();
        private final BuildOperationListener delegate;

        private ProgressShieldingBuildOperationListener(BuildOperationListener delegate) {
            this.delegate = delegate;
        }

        public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
            this.active.add(buildOperation.getId());
            this.delegate.started(buildOperation, startEvent);
        }

        public void progress(OperationIdentifier operationIdentifier, OperationProgressEvent progressEvent) {
            if (this.active.contains(operationIdentifier)) {
                this.delegate.progress(operationIdentifier, progressEvent);
            }
        }

        public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
            this.active.remove(buildOperation.getId());
            this.delegate.finished(buildOperation, finishEvent);
        }
    }
}

