/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.sink;

import java.io.Flushable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.api.logging.configuration.ConsoleOutput;
import org.gradle.internal.Factory;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.impldep.net.jcip.annotations.ThreadSafe;
import org.gradle.internal.logging.config.LoggingRouter;
import org.gradle.internal.logging.config.LoggingSystem;
import org.gradle.internal.logging.console.AnsiConsole;
import org.gradle.internal.logging.console.BuildLogLevelFilterRenderer;
import org.gradle.internal.logging.console.BuildStatusRenderer;
import org.gradle.internal.logging.console.ColorMap;
import org.gradle.internal.logging.console.Console;
import org.gradle.internal.logging.console.ConsoleLayoutCalculator;
import org.gradle.internal.logging.console.DefaultColorMap;
import org.gradle.internal.logging.console.DefaultWorkInProgressFormatter;
import org.gradle.internal.logging.console.StyledTextOutputBackedRenderer;
import org.gradle.internal.logging.console.ThrottlingOutputEventListener;
import org.gradle.internal.logging.console.UserInputConsoleRenderer;
import org.gradle.internal.logging.console.UserInputStandardOutputRenderer;
import org.gradle.internal.logging.console.WorkInProgressRenderer;
import org.gradle.internal.logging.events.EndOutputEvent;
import org.gradle.internal.logging.events.FlushOutputEvent;
import org.gradle.internal.logging.events.LogLevelChangeEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.events.RenderableOutputEvent;
import org.gradle.internal.logging.format.PrettyPrefixedLogHeaderFormatter;
import org.gradle.internal.logging.sink.ConsoleConfigureAction;
import org.gradle.internal.logging.sink.GroupingProgressLogEventGenerator;
import org.gradle.internal.logging.sink.LogEventDispatcher;
import org.gradle.internal.logging.sink.PlainConsoleDispatchingListener;
import org.gradle.internal.logging.sink.ProgressLogEventGenerator;
import org.gradle.internal.logging.text.StreamBackedStandardOutputListener;
import org.gradle.internal.logging.text.StreamingStyledTextOutput;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;
import org.gradle.internal.nativeintegration.console.FallbackConsoleMetaData;
import org.gradle.internal.time.Clock;

@ThreadSafe
public class OutputEventRenderer
implements OutputEventListener,
LoggingRouter {
    private final Object lock = new Object();
    private final AtomicReference<LogLevel> logLevel = new AtomicReference<LogLevel>(LogLevel.LIFECYCLE);
    private final Clock clock;
    private final ListenerBroadcast<OutputEventListener> formatters = new ListenerBroadcast<OutputEventListener>(OutputEventListener.class);
    private ColorMap colourMap;
    private OutputStream originalStdOut;
    private OutputStream originalStdErr;
    private OutputEventListener stdOutListener;
    private OutputEventListener stdErrListener;
    private OutputEventListener console;
    private OutputEventListener userListenerChain;
    private ListenerBroadcast<StandardOutputListener> userStdoutListeners;
    private ListenerBroadcast<StandardOutputListener> userStderrListeners;

    public OutputEventRenderer(Clock clock) {
        this.clock = clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggingSystem.Snapshot snapshot() {
        Object object = this.lock;
        synchronized (object) {
            return new SnapshotImpl(this.logLevel.get(), this.console);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(LoggingSystem.Snapshot state) {
        Object object = this.lock;
        synchronized (object) {
            SnapshotImpl snapshot = (SnapshotImpl)state;
            if (snapshot.logLevel != this.logLevel.get()) {
                this.configure(snapshot.logLevel);
            }
            if (snapshot.console != this.console) {
                if (snapshot.console == null) {
                    this.removeChain(this.console);
                    this.console = null;
                } else {
                    throw new UnsupportedOperationException("Cannot restore previous console. This is not implemented yet.");
                }
            }
        }
    }

    private void addChain(OutputEventListener listener) {
        listener.onOutput(new LogLevelChangeEvent(this.logLevel.get()));
        this.formatters.add(listener);
    }

    private void removeChain(OutputEventListener listener) {
        this.formatters.remove(listener);
        listener.onOutput(new EndOutputEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorMap getColourMap() {
        Object object = this.lock;
        synchronized (object) {
            if (this.colourMap == null) {
                this.colourMap = new DefaultColorMap();
            }
        }
        return this.colourMap;
    }

    public void flush() {
        this.onOutput(new FlushOutputEvent());
    }

    public OutputStream getOriginalStdOut() {
        return this.originalStdOut;
    }

    public OutputStream getOriginalStdErr() {
        return this.originalStdErr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachProcessConsole(ConsoleOutput consoleOutput) {
        Object object = this.lock;
        synchronized (object) {
            ConsoleConfigureAction.execute(this, consoleOutput);
        }
    }

    public void attachConsole(OutputStream outputStream, OutputStream errorStream, ConsoleOutput consoleOutput) {
        this.attachConsole(outputStream, errorStream, consoleOutput, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachConsole(OutputStream outputStream, OutputStream errorStream, ConsoleOutput consoleOutput, boolean consoleAttachedToStderr) {
        Object object = this.lock;
        synchronized (object) {
            if (consoleOutput == ConsoleOutput.Plain) {
                this.addPlainConsole(new StreamBackedStandardOutputListener(outputStream), new StreamBackedStandardOutputListener(errorStream), consoleAttachedToStderr);
            } else {
                FallbackConsoleMetaData consoleMetaData = FallbackConsoleMetaData.INSTANCE;
                OutputStreamWriter writer = new OutputStreamWriter(outputStream);
                AnsiConsole console = new AnsiConsole((Appendable)writer, (Flushable)writer, this.getColourMap(), (ConsoleMetaData)consoleMetaData, true);
                this.addRichConsole(console, true, consoleAttachedToStderr, consoleMetaData, consoleOutput == ConsoleOutput.Verbose);
                if (!consoleAttachedToStderr) {
                    this.addChain(this.onError(new StyledTextOutputBackedRenderer(new StreamingStyledTextOutput(new StreamBackedStandardOutputListener(errorStream)))));
                    this.removeSystemErrAsLoggingDestination();
                }
            }
        }
    }

    public void attachSystemOutAndErr() {
        this.addSystemOutAsLoggingDestination();
        this.addSystemErrAsLoggingDestination();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSystemOutAsLoggingDestination() {
        Object object = this.lock;
        synchronized (object) {
            this.originalStdOut = System.out;
            if (this.stdOutListener != null) {
                this.removeChain(this.stdOutListener);
            }
            this.stdOutListener = new LazyListener(new Factory<OutputEventListener>(){

                @Override
                public OutputEventListener create() {
                    return OutputEventRenderer.this.onNonError(new StyledTextOutputBackedRenderer(new StreamingStyledTextOutput(new StreamBackedStandardOutputListener((Appendable)((Object)OutputEventRenderer.this.originalStdOut)))));
                }
            });
            this.addChain(this.stdOutListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSystemErrAsLoggingDestination() {
        Object object = this.lock;
        synchronized (object) {
            this.originalStdErr = System.err;
            if (this.stdErrListener != null) {
                this.removeChain(this.stdErrListener);
            }
            this.stdErrListener = new LazyListener(new Factory<OutputEventListener>(){

                @Override
                public OutputEventListener create() {
                    return OutputEventRenderer.this.onError(new StyledTextOutputBackedRenderer(new StreamingStyledTextOutput(new StreamBackedStandardOutputListener((Appendable)((Object)OutputEventRenderer.this.originalStdErr)))));
                }
            });
            this.addChain(this.stdErrListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSystemOutAsLoggingDestination() {
        Object object = this.lock;
        synchronized (object) {
            if (this.stdOutListener != null) {
                this.removeChain(this.stdOutListener);
                this.stdOutListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSystemErrAsLoggingDestination() {
        Object object = this.lock;
        synchronized (object) {
            if (this.stdErrListener != null) {
                this.removeChain(this.stdErrListener);
                this.stdErrListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutputEventListener(OutputEventListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.addChain(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutputEventListener(OutputEventListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.removeChain(listener);
        }
    }

    public OutputEventRenderer addRichConsole(Console console, boolean stdout, boolean stderr, ConsoleMetaData consoleMetaData) {
        return this.addRichConsole(console, stdout, stderr, consoleMetaData, false);
    }

    public OutputEventRenderer addRichConsole(Console console, boolean stdout, boolean stderr, ConsoleMetaData consoleMetaData, boolean verbose) {
        ThrottlingOutputEventListener consoleChain = new ThrottlingOutputEventListener(new UserInputConsoleRenderer(new BuildStatusRenderer(new WorkInProgressRenderer(new BuildLogLevelFilterRenderer(new GroupingProgressLogEventGenerator(new StyledTextOutputBackedRenderer(console.getBuildOutputArea()), new PrettyPrefixedLogHeaderFormatter(), verbose)), console.getBuildProgressArea(), new DefaultWorkInProgressFormatter(consoleMetaData), new ConsoleLayoutCalculator(consoleMetaData)), console.getStatusBar(), console, consoleMetaData), console), this.clock);
        return this.addConsoleChain(consoleChain, stdout, stderr);
    }

    public OutputEventRenderer addPlainConsole(boolean redirectStderr) {
        return this.addPlainConsole(new StreamBackedStandardOutputListener((Appendable)((Object)this.originalStdOut)), new StreamBackedStandardOutputListener((Appendable)((Object)this.originalStdErr)), redirectStderr);
    }

    private OutputEventRenderer addPlainConsole(StandardOutputListener outputListener, StandardOutputListener errorListener, boolean redirectStderr) {
        UserInputStandardOutputRenderer stdoutChain = new UserInputStandardOutputRenderer(new StyledTextOutputBackedRenderer(new StreamingStyledTextOutput(outputListener)), this.clock);
        StyledTextOutputBackedRenderer stderrChain = new StyledTextOutputBackedRenderer(new StreamingStyledTextOutput(errorListener));
        ThrottlingOutputEventListener consoleChain = new ThrottlingOutputEventListener(new BuildLogLevelFilterRenderer(new GroupingProgressLogEventGenerator(new PlainConsoleDispatchingListener(stderrChain, stdoutChain, redirectStderr), new PrettyPrefixedLogHeaderFormatter(), true)), this.clock);
        return this.addConsoleChain(consoleChain, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutputEventRenderer addConsoleChain(OutputEventListener consoleChain, boolean stdout, boolean stderr) {
        Object object = this.lock;
        synchronized (object) {
            if (stdout && stderr) {
                this.console = consoleChain;
                this.removeSystemOutAsLoggingDestination();
                this.removeSystemErrAsLoggingDestination();
            } else if (stdout) {
                this.console = this.onNonError(consoleChain);
                this.removeSystemOutAsLoggingDestination();
            } else if (stderr) {
                this.console = this.onError(consoleChain);
                this.removeSystemErrAsLoggingDestination();
            } else {
                this.console = consoleChain;
            }
            this.addChain(this.console);
        }
        return this;
    }

    private OutputEventListener onError(OutputEventListener listener) {
        return new LogEventDispatcher(null, listener);
    }

    private OutputEventListener onNonError(OutputEventListener listener) {
        return new LogEventDispatcher(listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableUserStandardOutputListeners() {
        Object object = this.lock;
        synchronized (object) {
            if (this.userStdoutListeners == null) {
                this.userStdoutListeners = new ListenerBroadcast<StandardOutputListener>(StandardOutputListener.class);
                this.userStderrListeners = new ListenerBroadcast<StandardOutputListener>(StandardOutputListener.class);
                final StyledTextOutputBackedRenderer stdOutChain = new StyledTextOutputBackedRenderer(new StreamingStyledTextOutput(this.userStdoutListeners.getSource()));
                final StyledTextOutputBackedRenderer stdErrChain = new StyledTextOutputBackedRenderer(new StreamingStyledTextOutput(this.userStderrListeners.getSource()));
                this.userListenerChain = new BuildLogLevelFilterRenderer(new ProgressLogEventGenerator(new OutputEventListener(){

                    public void onOutput(OutputEvent event) {
                        if (event instanceof LogLevelChangeEvent) {
                            stdOutChain.onOutput(event);
                            stdErrChain.onOutput(event);
                        } else if (event.getLogLevel() == LogLevel.ERROR && !OutputEventRenderer.this.userStderrListeners.isEmpty() && event instanceof RenderableOutputEvent) {
                            stdErrChain.onOutput(event);
                        } else if (event.getLogLevel() != LogLevel.ERROR && !OutputEventRenderer.this.userStdoutListeners.isEmpty() && event instanceof RenderableOutputEvent) {
                            stdOutChain.onOutput(event);
                        }
                    }
                }));
                this.addChain(this.userListenerChain);
            }
        }
    }

    private void assertUserListenersEnabled() {
        if (this.userListenerChain == null) {
            throw new IllegalStateException("Custom standard output listeners not enabled.");
        }
        this.userListenerChain.onOutput(new FlushOutputEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStandardErrorListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.assertUserListenersEnabled();
            this.userStderrListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStandardOutputListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.assertUserListenersEnabled();
            this.userStdoutListeners.add(listener);
        }
    }

    public void addStandardOutputListener(OutputStream outputStream) {
        this.addStandardOutputListener(new StreamBackedStandardOutputListener(outputStream));
    }

    public void addStandardErrorListener(OutputStream outputStream) {
        this.addStandardErrorListener(new StreamBackedStandardOutputListener(outputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStandardOutputListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.assertUserListenersEnabled();
            this.userStdoutListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStandardErrorListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.assertUserListenersEnabled();
            this.userStderrListeners.remove(listener);
        }
    }

    public void configure(LogLevel logLevel) {
        this.onOutput(new LogLevelChangeEvent(logLevel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOutput(OutputEvent event) {
        if (event.getLogLevel() != null && event.getLogLevel().compareTo((Enum)this.logLevel.get()) < 0 && !this.isProgressEvent(event)) {
            return;
        }
        if (event instanceof LogLevelChangeEvent) {
            LogLevelChangeEvent changeEvent = (LogLevelChangeEvent)event;
            LogLevel newLogLevel = changeEvent.getNewLogLevel();
            if (newLogLevel == this.logLevel.get()) {
                return;
            }
            this.logLevel.set(newLogLevel);
        }
        Object object = this.lock;
        synchronized (object) {
            this.formatters.getSource().onOutput(event);
        }
    }

    private boolean isProgressEvent(OutputEvent event) {
        return event instanceof ProgressStartEvent || event instanceof ProgressEvent || event instanceof ProgressCompleteEvent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyListener
    implements OutputEventListener {
        private Factory<OutputEventListener> factory;
        private OutputEventListener delegate;
        private LogLevelChangeEvent pendingLogLevel;

        private LazyListener(Factory<OutputEventListener> factory) {
            this.factory = factory;
        }

        @Override
        public void onOutput(OutputEvent event) {
            if (this.delegate == null) {
                if (event instanceof EndOutputEvent || event instanceof FlushOutputEvent) {
                    return;
                }
                if (event instanceof LogLevelChangeEvent) {
                    this.pendingLogLevel = (LogLevelChangeEvent)event;
                    return;
                }
                this.delegate = this.factory.create();
                this.factory = null;
                if (this.pendingLogLevel != null) {
                    this.delegate.onOutput(this.pendingLogLevel);
                    this.pendingLogLevel = null;
                }
            }
            this.delegate.onOutput(event);
        }
    }

    private static class SnapshotImpl
    implements LoggingSystem.Snapshot {
        private final LogLevel logLevel;
        private final OutputEventListener console;

        SnapshotImpl(LogLevel logLevel, OutputEventListener console) {
            this.logLevel = logLevel;
            this.console = console;
        }
    }
}

