/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.services;

import java.io.Closeable;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.api.logging.configuration.ConsoleOutput;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.LoggingOutputInternal;
import org.gradle.internal.logging.config.LoggingRouter;
import org.gradle.internal.logging.config.LoggingSourceSystem;
import org.gradle.internal.logging.config.LoggingSystem;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.text.StreamBackedStandardOutputListener;

public class DefaultLoggingManager
implements LoggingManagerInternal,
Closeable {
    private boolean started;
    private final StartableLoggingSystem slf4jLoggingSystem;
    private final StartableLoggingSystem stdOutLoggingSystem;
    private final StartableLoggingSystem stdErrLoggingSystem;
    private final StartableLoggingSystem javaUtilLoggingSystem;
    private final StartableLoggingRouter loggingRouter;
    private boolean enableStdOutListeners;
    private final LoggingOutputInternal loggingOutput;
    private final Set<StandardOutputListener> stdoutListeners = new LinkedHashSet<StandardOutputListener>();
    private final Set<StandardOutputListener> stderrListeners = new LinkedHashSet<StandardOutputListener>();
    private final Set<OutputEventListener> outputEventListeners = new LinkedHashSet<OutputEventListener>();

    public DefaultLoggingManager(LoggingSourceSystem slf4jLoggingSystem, LoggingSourceSystem javaUtilLoggingSystem, LoggingSourceSystem stdOutLoggingSystem, LoggingSourceSystem stdErrLoggingSystem, LoggingRouter loggingRouter) {
        this.loggingOutput = loggingRouter;
        this.loggingRouter = new StartableLoggingRouter(loggingRouter);
        this.slf4jLoggingSystem = new StartableLoggingSystem(slf4jLoggingSystem, null);
        this.stdOutLoggingSystem = new StartableLoggingSystem(stdOutLoggingSystem, null);
        this.stdErrLoggingSystem = new StartableLoggingSystem(stdErrLoggingSystem, null);
        this.javaUtilLoggingSystem = new StartableLoggingSystem(javaUtilLoggingSystem, null);
    }

    public DefaultLoggingManager start() {
        this.started = true;
        if (this.enableStdOutListeners) {
            this.loggingRouter.loggingRouter.enableUserStandardOutputListeners();
        }
        for (StandardOutputListener stdoutListener : this.stdoutListeners) {
            this.loggingOutput.addStandardOutputListener(stdoutListener);
        }
        for (StandardOutputListener stderrListener : this.stderrListeners) {
            this.loggingOutput.addStandardErrorListener(stderrListener);
        }
        for (OutputEventListener outputEventListener : this.outputEventListeners) {
            this.loggingOutput.addOutputEventListener(outputEventListener);
        }
        this.loggingRouter.start();
        this.slf4jLoggingSystem.enableCapture();
        this.slf4jLoggingSystem.start();
        this.javaUtilLoggingSystem.start();
        this.stdOutLoggingSystem.start();
        this.stdErrLoggingSystem.start();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultLoggingManager stop() {
        try {
            CompositeStoppable.stoppable(this.slf4jLoggingSystem, this.javaUtilLoggingSystem, this.stdOutLoggingSystem, this.stdErrLoggingSystem).stop();
            for (StandardOutputListener stdoutListener : this.stdoutListeners) {
                this.loggingOutput.removeStandardOutputListener(stdoutListener);
            }
            for (StandardOutputListener stderrListener : this.stderrListeners) {
                this.loggingOutput.removeStandardErrorListener(stderrListener);
            }
            for (OutputEventListener listener : this.outputEventListeners) {
                this.loggingOutput.removeOutputEventListener(listener);
            }
            this.loggingRouter.stop();
        }
        finally {
            this.started = false;
        }
        return this;
    }

    public void close() {
        this.stop();
    }

    public DefaultLoggingManager setLevelInternal(LogLevel logLevel) {
        this.slf4jLoggingSystem.setLevel(logLevel);
        this.javaUtilLoggingSystem.setLevel(logLevel);
        this.loggingRouter.setLevel(logLevel);
        return this;
    }

    public LogLevel getLevel() {
        return this.slf4jLoggingSystem.level;
    }

    public DefaultLoggingManager captureSystemSources() {
        this.stdOutLoggingSystem.enableCapture();
        this.stdErrLoggingSystem.enableCapture();
        this.javaUtilLoggingSystem.enableCapture();
        return this;
    }

    public LogLevel getStandardOutputCaptureLevel() {
        return this.stdOutLoggingSystem.level;
    }

    public DefaultLoggingManager captureStandardOutput(LogLevel level) {
        this.stdOutLoggingSystem.setLevel(level);
        return this;
    }

    public DefaultLoggingManager captureStandardError(LogLevel level) {
        this.stdErrLoggingSystem.setLevel(level);
        return this;
    }

    public LogLevel getStandardErrorCaptureLevel() {
        return this.stdErrLoggingSystem.level;
    }

    public LoggingManagerInternal enableUserStandardOutputListeners() {
        this.enableStdOutListeners = true;
        return this;
    }

    public void addStandardOutputListener(StandardOutputListener listener) {
        if (this.stdoutListeners.add(listener) && this.started) {
            this.loggingOutput.addStandardOutputListener(listener);
        }
    }

    public void addStandardErrorListener(StandardOutputListener listener) {
        if (this.stderrListeners.add(listener) && this.started) {
            this.loggingOutput.addStandardErrorListener(listener);
        }
    }

    public void addStandardOutputListener(OutputStream outputStream) {
        this.addStandardOutputListener(new StreamBackedStandardOutputListener(outputStream));
    }

    public void addStandardErrorListener(OutputStream outputStream) {
        this.addStandardErrorListener(new StreamBackedStandardOutputListener(outputStream));
    }

    public void removeStandardOutputListener(StandardOutputListener listener) {
        if (this.stdoutListeners.remove(listener) && this.started) {
            this.loggingOutput.removeStandardOutputListener(listener);
        }
    }

    public void removeStandardErrorListener(StandardOutputListener listener) {
        if (this.stderrListeners.remove(listener) && this.started) {
            this.loggingOutput.removeStandardErrorListener(listener);
        }
    }

    public void addOutputEventListener(OutputEventListener listener) {
        if (this.outputEventListeners.add(listener) && this.started) {
            this.loggingOutput.addOutputEventListener(listener);
        }
    }

    public void removeOutputEventListener(OutputEventListener listener) {
        if (this.outputEventListeners.remove(listener) && this.started) {
            this.loggingOutput.removeOutputEventListener(listener);
        }
    }

    public void attachProcessConsole(ConsoleOutput consoleOutput) {
        this.loggingRouter.attachProcessConsole(consoleOutput);
    }

    public void attachConsole(OutputStream outputStream, OutputStream errorStream, ConsoleOutput consoleOutput) {
        this.loggingRouter.attachConsole(outputStream, errorStream, consoleOutput, true);
    }

    public void attachConsole(OutputStream outputStream, OutputStream errorStream, ConsoleOutput consoleOutput, boolean consoleAttachedToStderr) {
        this.loggingRouter.attachConsole(outputStream, errorStream, consoleOutput, consoleAttachedToStderr);
    }

    public void attachSystemOutAndErr() {
        this.loggingOutput.attachSystemOutAndErr();
    }

    public void flush() {
        this.loggingRouter.flush();
    }

    private static class ConsoleAttachment
    implements Runnable {
        private final LoggingRouter loggingRouter;
        private final OutputStream outputStream;
        private final OutputStream errorStream;
        private final ConsoleOutput consoleOutput;
        private final boolean consoleAttachedToStderr;

        ConsoleAttachment(LoggingRouter loggingRouter, OutputStream outputStream, OutputStream errorStream, ConsoleOutput consoleOutput, boolean consoleAttachedToStderr) {
            this.loggingRouter = loggingRouter;
            this.outputStream = outputStream;
            this.errorStream = errorStream;
            this.consoleOutput = consoleOutput;
            this.consoleAttachedToStderr = consoleAttachedToStderr;
        }

        public void run() {
            this.loggingRouter.attachConsole(this.outputStream, this.errorStream, this.consoleOutput, this.consoleAttachedToStderr);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConsoleAttachment that = (ConsoleAttachment)o;
            return this.outputStream == that.outputStream && this.errorStream == that.errorStream && this.consoleOutput == that.consoleOutput && this.consoleAttachedToStderr == that.consoleAttachedToStderr;
        }

        public int hashCode() {
            return this.outputStream.hashCode() ^ this.errorStream.hashCode();
        }
    }

    private static class ProcessConsoleAttachment
    implements Runnable {
        private final LoggingRouter loggingRouter;
        private final ConsoleOutput consoleOutput;

        ProcessConsoleAttachment(LoggingRouter loggingRouter, ConsoleOutput consoleOutput) {
            this.loggingRouter = loggingRouter;
            this.consoleOutput = consoleOutput;
        }

        public void run() {
            this.loggingRouter.attachProcessConsole(this.consoleOutput);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProcessConsoleAttachment that = (ProcessConsoleAttachment)o;
            return this.consoleOutput == that.consoleOutput;
        }

        public int hashCode() {
            return this.consoleOutput.hashCode();
        }
    }

    private static class StartableLoggingSystem
    implements Stoppable {
        private final LoggingSourceSystem loggingSystem;
        private boolean enabled;
        private LogLevel level;
        private LoggingSystem.Snapshot originalState;

        private StartableLoggingSystem(LoggingSourceSystem loggingSystem, LogLevel level) {
            this.loggingSystem = loggingSystem;
            this.level = level;
        }

        public void start() {
            this.originalState = this.loggingSystem.snapshot();
            if (this.level != null) {
                this.loggingSystem.setLevel(this.level);
            }
            if (this.enabled) {
                this.loggingSystem.startCapture();
            }
        }

        public void enableCapture() {
            if (this.enabled) {
                return;
            }
            this.enabled = true;
            if (this.originalState != null) {
                this.loggingSystem.startCapture();
            }
        }

        public void setLevel(LogLevel logLevel) {
            if (this.level == logLevel) {
                return;
            }
            this.level = logLevel;
            if (this.originalState != null) {
                this.loggingSystem.setLevel(logLevel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            try {
                if (this.originalState != null) {
                    this.loggingSystem.restore(this.originalState);
                }
            }
            finally {
                this.enabled = false;
                this.originalState = null;
            }
        }
    }

    private static class StartableLoggingRouter
    implements Stoppable {
        private final LoggingRouter loggingRouter;
        private LogLevel level;
        private LoggingSystem.Snapshot originalState;
        private Runnable consoleAttachment;

        StartableLoggingRouter(LoggingRouter loggingRouter) {
            this.loggingRouter = loggingRouter;
        }

        public void start() {
            this.originalState = this.loggingRouter.snapshot();
            if (this.level != null) {
                this.loggingRouter.configure(this.level);
            }
            if (this.consoleAttachment != null) {
                this.consoleAttachment.run();
            }
        }

        private void addConsoleAttachement(Runnable consoleAttachment) {
            if (consoleAttachment.equals(this.consoleAttachment)) {
                return;
            }
            if (this.consoleAttachment != null) {
                throw new UnsupportedOperationException("Not implemented yet.");
            }
            if (this.originalState != null) {
                consoleAttachment.run();
            }
            this.consoleAttachment = consoleAttachment;
        }

        void attachProcessConsole(ConsoleOutput consoleOutput) {
            this.addConsoleAttachement(new ProcessConsoleAttachment(this.loggingRouter, consoleOutput));
        }

        void attachConsole(OutputStream outputStream, OutputStream errorStream, ConsoleOutput consoleOutput, boolean consoleAttachedToStderr) {
            this.addConsoleAttachement(new ConsoleAttachment(this.loggingRouter, outputStream, errorStream, consoleOutput, consoleAttachedToStderr));
        }

        public void setLevel(LogLevel logLevel) {
            if (this.level == logLevel) {
                return;
            }
            if (this.originalState != null) {
                this.loggingRouter.configure(logLevel);
            }
            this.level = logLevel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            try {
                if (this.originalState != null) {
                    this.loggingRouter.restore(this.originalState);
                }
            }
            finally {
                this.originalState = null;
            }
        }

        public void flush() {
            this.loggingRouter.flush();
        }
    }
}

