/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.serializer;

import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressStartEventSerializer
implements Serializer<ProgressStartEvent> {
    private static final short PARENT_PROGRESS_ID = 1;
    private static final short SHORT_DESCRIPTION = 4;
    private static final short SHORT_DESCRIPTION_IS_DESCRIPTION = 8;
    private static final short LOGGING_HEADER = 16;
    private static final short LOGGING_HEADER_IS_SHORT_DESCRIPTION = 32;
    private static final short STATUS = 64;
    private static final short BUILD_OPERATION_ID = 128;
    private static final short BUILD_OPERATION_START = 256;
    private static final short PARENT_BUILD_OPERATION_ID = 512;
    private static final short BUILD_OPERATION_CATEGORY_TASK = 1024;
    private static final short BUILD_OPERATION_CATEGORY_PROJECT = 2048;

    @Override
    public void write(Encoder encoder, ProgressStartEvent event) throws Exception {
        BuildOperationCategory buildOperationCategory;
        OperationIdentifier parentBuildOperationId;
        OperationIdentifier buildOperationId;
        String loggingHeader;
        String shortDescription;
        int flags = 0;
        OperationIdentifier parentProgressOperationId = event.getParentProgressOperationId();
        if (parentProgressOperationId != null) {
            flags |= 1;
        }
        if ((shortDescription = event.getShortDescription()) != null) {
            flags = shortDescription.equals(event.getDescription()) ? (flags |= 8) : (flags |= 4);
        }
        if ((loggingHeader = event.getLoggingHeader()) != null) {
            flags = loggingHeader.equals(shortDescription) ? (flags |= 0x20) : (flags |= 0x10);
        }
        if (!event.getStatus().isEmpty()) {
            flags |= 0x40;
        }
        if ((buildOperationId = event.getBuildOperationId()) != null) {
            flags |= 0x80;
        }
        if ((parentBuildOperationId = event.getParentBuildOperationId()) != null) {
            flags |= 0x200;
        }
        if ((buildOperationCategory = event.getBuildOperationCategory()) == BuildOperationCategory.CONFIGURE_PROJECT) {
            flags |= 0x800;
        } else if (buildOperationCategory == BuildOperationCategory.TASK) {
            flags |= 0x400;
        } else if (buildOperationCategory != BuildOperationCategory.UNCATEGORIZED) {
            throw new IllegalArgumentException("Can't handle build operation category " + (Object)((Object)buildOperationCategory));
        }
        if (event.isBuildOperationStart()) {
            flags |= 0x100;
        }
        encoder.writeSmallInt(flags);
        encoder.writeSmallLong(event.getProgressOperationId().getId());
        if (parentProgressOperationId != null) {
            encoder.writeSmallLong(parentProgressOperationId.getId());
        }
        encoder.writeLong(event.getTimestamp());
        encoder.writeString(event.getCategory());
        encoder.writeString(event.getDescription());
        if ((flags & 4) != 0) {
            encoder.writeString(shortDescription);
        }
        if ((flags & 0x10) != 0) {
            encoder.writeString(loggingHeader);
        }
        if ((flags & 0x40) != 0) {
            encoder.writeString(event.getStatus());
        }
        encoder.writeInt(event.getTotalProgress());
        if (buildOperationId != null) {
            encoder.writeSmallLong(buildOperationId.getId());
        }
        if (parentBuildOperationId != null) {
            encoder.writeSmallLong(parentBuildOperationId.getId());
        }
    }

    @Override
    public ProgressStartEvent read(Decoder decoder) throws Exception {
        long flags = decoder.readSmallInt();
        OperationIdentifier progressOperationId = new OperationIdentifier(decoder.readSmallLong());
        OperationIdentifier parentProgressOperationId = null;
        if ((flags & 1L) != 0L) {
            parentProgressOperationId = new OperationIdentifier(decoder.readSmallLong());
        }
        long timestamp = decoder.readLong();
        String category = decoder.readString();
        String description = decoder.readString();
        String shortDescription = null;
        if ((flags & 8L) != 0L) {
            shortDescription = description;
        } else if ((flags & 4L) != 0L) {
            shortDescription = decoder.readString();
        }
        String loggingHeader = null;
        if ((flags & 0x20L) != 0L) {
            loggingHeader = shortDescription;
        } else if ((flags & 0x10L) != 0L) {
            loggingHeader = decoder.readString();
        }
        String status = "";
        if ((flags & 0x40L) != 0L) {
            status = decoder.readString();
        }
        int totalProgress = decoder.readInt();
        boolean buildOperationStart = (flags & 0x100L) != 0L;
        OperationIdentifier buildOperationId = null;
        if ((flags & 0x80L) != 0L) {
            buildOperationId = new OperationIdentifier(decoder.readSmallLong());
        }
        OperationIdentifier parentBuildOperationId = null;
        if ((flags & 0x200L) != 0L) {
            parentBuildOperationId = new OperationIdentifier(decoder.readSmallLong());
        }
        BuildOperationCategory buildOperationCategory = (flags & 0x800L) != 0L ? BuildOperationCategory.CONFIGURE_PROJECT : ((flags & 0x400L) != 0L ? BuildOperationCategory.TASK : BuildOperationCategory.UNCATEGORIZED);
        return new ProgressStartEvent(progressOperationId, parentProgressOperationId, timestamp, category, description, shortDescription, loggingHeader, status, totalProgress, buildOperationStart, buildOperationId, parentBuildOperationId, buildOperationCategory);
    }
}

