/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.logging.console.BuildProgressArea;
import org.gradle.internal.logging.console.ConsoleLayoutCalculator;
import org.gradle.internal.logging.console.DefaultWorkInProgressFormatter;
import org.gradle.internal.logging.console.ProgressOperation;
import org.gradle.internal.logging.console.ProgressOperations;
import org.gradle.internal.logging.console.StyledLabel;
import org.gradle.internal.logging.events.EndOutputEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.events.UpdateNowEvent;
import org.gradle.internal.operations.OperationIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkInProgressRenderer
implements OutputEventListener {
    private final OutputEventListener listener;
    private final ProgressOperations operations = new ProgressOperations();
    private final BuildProgressArea progressArea;
    private final DefaultWorkInProgressFormatter labelFormatter;
    private final ConsoleLayoutCalculator consoleLayoutCalculator;
    private final List<OutputEvent> queue = new ArrayList<OutputEvent>();
    private final Deque<StyledLabel> unusedProgressLabels;
    private final Map<OperationIdentifier, AssociationLabel> operationIdToAssignedLabels = new HashMap<OperationIdentifier, AssociationLabel>();
    private final Deque<ProgressOperation> unassignedProgressOperations = new ArrayDeque<ProgressOperation>();

    public WorkInProgressRenderer(OutputEventListener listener, BuildProgressArea progressArea, DefaultWorkInProgressFormatter labelFormatter, ConsoleLayoutCalculator consoleLayoutCalculator) {
        this.listener = listener;
        this.progressArea = progressArea;
        this.labelFormatter = labelFormatter;
        this.consoleLayoutCalculator = consoleLayoutCalculator;
        this.unusedProgressLabels = new ArrayDeque<StyledLabel>(progressArea.getBuildProgressLabels());
    }

    @Override
    public void onOutput(OutputEvent event) {
        this.queue.add(event);
        if (event instanceof UpdateNowEvent) {
            this.renderNow();
        } else if (event instanceof EndOutputEvent) {
            this.progressArea.setVisible(false);
        }
        this.listener.onOutput(event);
    }

    private Set<OperationIdentifier> toOperationIdSet(Iterable<ProgressCompleteEvent> events) {
        return Sets.newHashSet((Iterable)Iterables.transform(events, (Function)new Function<ProgressCompleteEvent, OperationIdentifier>(){

            public OperationIdentifier apply(ProgressCompleteEvent event) {
                return event.getProgressOperationId();
            }
        }));
    }

    private void resizeTo(int newBuildProgressLabelCount) {
        int previousBuildProgressLabelCount = this.progressArea.getBuildProgressLabels().size();
        if (previousBuildProgressLabelCount >= (newBuildProgressLabelCount = this.consoleLayoutCalculator.calculateNumWorkersForConsoleDisplay(newBuildProgressLabelCount))) {
            return;
        }
        this.progressArea.resizeBuildProgressTo(newBuildProgressLabelCount);
        for (int i = newBuildProgressLabelCount - 1; i >= previousBuildProgressLabelCount; --i) {
            this.unusedProgressLabels.push(this.progressArea.getBuildProgressLabels().get(i));
        }
    }

    private void attach(ProgressOperation operation) {
        if (operation.hasChildren() || !this.isRenderable(operation)) {
            return;
        }
        if (operation.getParent() != null) {
            this.detach(operation.getParent().getOperationId());
        }
        if (this.unusedProgressLabels.isEmpty()) {
            int newValue = this.operationIdToAssignedLabels.size() + 1;
            this.resizeTo(newValue);
        }
        if (this.unusedProgressLabels.isEmpty()) {
            this.unassignedProgressOperations.add(operation);
        } else {
            this.attach(operation, this.unusedProgressLabels.pop());
        }
    }

    private void attach(ProgressOperation operation, StyledLabel label) {
        AssociationLabel association = new AssociationLabel(operation, label);
        this.operationIdToAssignedLabels.put(operation.getOperationId(), association);
    }

    private void detach(ProgressOperation operation) {
        if (!this.isRenderable(operation)) {
            return;
        }
        this.detach(operation.getOperationId());
        this.unassignedProgressOperations.remove(operation);
        if (operation.getParent() != null && this.isRenderable(operation.getParent())) {
            this.attach(operation.getParent());
        } else if (!this.unassignedProgressOperations.isEmpty()) {
            this.attach(this.unassignedProgressOperations.pop());
        }
    }

    private void detach(OperationIdentifier operationId) {
        AssociationLabel association = this.operationIdToAssignedLabels.remove(operationId);
        if (association != null) {
            this.unusedProgressLabels.push(association.label);
        }
    }

    private boolean isRenderable(ProgressOperation operation) {
        for (ProgressOperation current = operation; current != null && !"org.gradle.internal.progress.BuildProgressLogger".equals(current.getCategory()); current = current.getParent()) {
            if (current.getMessage() == null) continue;
            return true;
        }
        return false;
    }

    private void renderNow() {
        if (this.queue.isEmpty()) {
            return;
        }
        Set<OperationIdentifier> completeEventOperationIds = this.toOperationIdSet(Iterables.filter(this.queue, ProgressCompleteEvent.class));
        HashSet<OperationIdentifier> operationIdsToSkip = new HashSet<OperationIdentifier>();
        for (OutputEvent event : this.queue) {
            ProgressEvent progressEvent;
            if (event instanceof ProgressStartEvent) {
                this.progressArea.setVisible(true);
                ProgressStartEvent startEvent = (ProgressStartEvent)event;
                if (completeEventOperationIds.contains(startEvent.getProgressOperationId())) {
                    operationIdsToSkip.add(startEvent.getProgressOperationId());
                    continue;
                }
                this.attach(this.operations.start(startEvent.getShortDescription(), startEvent.getStatus(), startEvent.getCategory(), startEvent.getProgressOperationId(), startEvent.getParentProgressOperationId()));
                continue;
            }
            if (event instanceof ProgressCompleteEvent) {
                ProgressCompleteEvent completeEvent = (ProgressCompleteEvent)event;
                if (operationIdsToSkip.contains(completeEvent.getProgressOperationId())) continue;
                this.detach(this.operations.complete(completeEvent.getProgressOperationId()));
                continue;
            }
            if (!(event instanceof ProgressEvent) || operationIdsToSkip.contains((progressEvent = (ProgressEvent)event).getProgressOperationId())) continue;
            this.operations.progress(progressEvent.getStatus(), progressEvent.getProgressOperationId());
        }
        this.queue.clear();
        for (AssociationLabel associatedLabel : this.operationIdToAssignedLabels.values()) {
            associatedLabel.renderNow();
        }
        for (StyledLabel emptyLabel : this.unusedProgressLabels) {
            emptyLabel.setText(this.labelFormatter.format());
        }
    }

    private class AssociationLabel {
        final ProgressOperation operation;
        final StyledLabel label;

        AssociationLabel(ProgressOperation operation, StyledLabel label) {
            this.operation = operation;
            this.label = label;
        }

        void renderNow() {
            this.label.setText(WorkInProgressRenderer.this.labelFormatter.format(this.operation));
        }
    }
}

