/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.util.List;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.logging.events.StyledTextOutputEvent;
import org.gradle.internal.logging.format.TersePrettyDurationFormatter;
import org.gradle.internal.logging.text.StyledTextOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressBar {
    private final TersePrettyDurationFormatter elapsedTimeFormatter = new TersePrettyDurationFormatter();
    private final String progressBarPrefix;
    private int progressBarWidth;
    private final String progressBarSuffix;
    private char fillerChar;
    private final char incompleteChar;
    private String suffix;
    private int current;
    private int total;
    private boolean failing;

    public ProgressBar(String progressBarPrefix, int progressBarWidth, String progressBarSuffix, char completeChar, char incompleteChar, String suffix, int initialProgress, int totalProgress) {
        this.progressBarPrefix = progressBarPrefix;
        this.progressBarWidth = progressBarWidth;
        this.progressBarSuffix = progressBarSuffix;
        this.fillerChar = completeChar;
        this.incompleteChar = incompleteChar;
        this.suffix = suffix;
        this.current = initialProgress;
        this.total = totalProgress;
    }

    public void update(boolean failing) {
        ++this.current;
        this.failing = this.failing || failing;
    }

    public List<StyledTextOutputEvent.Span> formatProgress(int consoleCols, boolean timerEnabled, long elapsedTime) {
        int completedWidth = (int)((double)this.current * 1.0 / (double)this.total * (double)this.progressBarWidth);
        int remainingWidth = this.progressBarWidth - completedWidth;
        String statusPrefix = this.trimToConsole(consoleCols, 0, this.progressBarPrefix);
        String coloredProgress = this.trimToConsole(consoleCols, statusPrefix.length(), new String(new char[completedWidth]).replace('\u0000', this.fillerChar));
        String statusSuffix = this.trimToConsole(consoleCols, coloredProgress.length(), new String(new char[remainingWidth]).replace('\u0000', this.incompleteChar) + this.progressBarSuffix + " " + (int)((double)this.current * 100.0 / (double)this.total) + '%' + ' ' + this.suffix + (timerEnabled ? " [" + this.elapsedTimeFormatter.format(elapsedTime) + "]" : ""));
        return Lists.newArrayList((Object[])new StyledTextOutputEvent.Span[]{new StyledTextOutputEvent.Span(StyledTextOutput.Style.Header, statusPrefix), new StyledTextOutputEvent.Span(this.failing ? StyledTextOutput.Style.FailureHeader : StyledTextOutput.Style.SuccessHeader, coloredProgress), new StyledTextOutputEvent.Span(StyledTextOutput.Style.Header, statusSuffix)});
    }

    private String trimToConsole(int cols, int prefixLength, String str) {
        int consoleWidth = cols - 1;
        int remainingWidth = consoleWidth - prefixLength;
        if (consoleWidth < 0) {
            return str;
        }
        if (remainingWidth <= 0) {
            return "";
        }
        if (consoleWidth < str.length()) {
            return str.substring(0, consoleWidth);
        }
        return str;
    }
}

