/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import org.gradle.api.Action;
import org.gradle.internal.logging.console.AnsiContext;
import org.gradle.internal.logging.console.AnsiExecutor;
import org.gradle.internal.logging.console.Cursor;
import org.gradle.internal.logging.console.TextArea;
import org.gradle.internal.logging.text.AbstractLineChoppingStyledTextOutput;

public class DefaultTextArea
extends AbstractLineChoppingStyledTextOutput
implements TextArea {
    private static final Action<AnsiContext> NEW_LINE_ACTION = new Action<AnsiContext>(){

        @Override
        public void execute(AnsiContext ansi) {
            ansi.newLine();
        }
    };
    private static final int CHARS_PER_TAB_STOP = 8;
    private final Cursor writePos = new Cursor();
    private final AnsiExecutor ansiExecutor;

    public DefaultTextArea(AnsiExecutor ansiExecutor) {
        this.ansiExecutor = ansiExecutor;
    }

    public Cursor getWritePosition() {
        return this.writePos;
    }

    public void newLineAdjustment() {
        ++this.writePos.row;
    }

    protected void doLineText(final CharSequence text) {
        if (text.length() == 0) {
            return;
        }
        this.ansiExecutor.writeAt(this.writePos, (Action<? super AnsiContext>)new Action<AnsiContext>(){

            @Override
            public void execute(AnsiContext ansi) {
                ansi.withStyle(DefaultTextArea.this.getStyle(), (Action<? super AnsiContext>)new Action<AnsiContext>(){

                    @Override
                    public void execute(AnsiContext ansi) {
                        String textStr = text.toString();
                        int pos = 0;
                        while (pos < text.length()) {
                            int next = textStr.indexOf(9, pos);
                            if (next == pos) {
                                int charsToNextStop = 8 - ((DefaultTextArea)DefaultTextArea.this).writePos.col % 8;
                                for (int i = 0; i < charsToNextStop; ++i) {
                                    ansi.a(" ");
                                }
                                ++pos;
                                continue;
                            }
                            if (next > pos) {
                                ansi.a(textStr.substring(pos, next));
                                pos = next;
                                continue;
                            }
                            ansi.a(textStr.substring(pos, textStr.length()));
                            pos = textStr.length();
                        }
                    }
                });
            }
        });
    }

    protected void doEndLine(CharSequence endOfLine) {
        this.ansiExecutor.writeAt(this.writePos, NEW_LINE_ACTION);
    }
}

