/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.locking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DependencyArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.RootGraphNode;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotComponentIdentifier;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.local.model.RootConfigurationMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.locking.LockOutOfDateException;

public class DependencyLockingArtifactVisitor
implements DependencyArtifactsVisitor {
    private static final Logger LOGGER = Logging.getLogger(DependencyLockingArtifactVisitor.class);
    private final DependencyLockingProvider dependencyLockingProvider;
    private final String configurationName;
    private Set<String> lockingConstraints = Collections.emptySet();
    private Set<ModuleComponentIdentifier> allResolvedModules;
    private Set<ModuleComponentIdentifier> changingResolvedModules;
    private Set<String> extraModules;
    private DependencyLockingState dependencyLockingState;

    public DependencyLockingArtifactVisitor(String configurationName, DependencyLockingProvider dependencyLockingProvider) {
        this.configurationName = configurationName;
        this.dependencyLockingProvider = dependencyLockingProvider;
    }

    @Override
    public void startArtifacts(RootGraphNode root) {
        RootConfigurationMetadata metadata = root.getMetadata();
        this.dependencyLockingState = metadata.getDependencyLockingState();
        if (this.dependencyLockingState.mustValidateLockState()) {
            Set<DependencyConstraint> lockConstraints = this.dependencyLockingState.getLockedDependencies();
            this.lockingConstraints = Sets.newHashSetWithExpectedSize((int)lockConstraints.size());
            for (DependencyConstraint constraint : lockConstraints) {
                this.lockingConstraints.add(constraint.getGroup() + ":" + constraint.getName() + ":" + constraint.getVersionConstraint().getPreferredVersion());
            }
            this.allResolvedModules = Sets.newHashSetWithExpectedSize((int)this.lockingConstraints.size());
            this.extraModules = new TreeSet<String>();
        } else {
            this.allResolvedModules = new HashSet<ModuleComponentIdentifier>();
        }
    }

    @Override
    public void visitNode(DependencyGraphNode node) {
        boolean changing = false;
        ComponentIdentifier identifier = node.getOwner().getComponentId();
        ComponentResolveMetadata metadata = node.getOwner().getMetadata();
        if (metadata != null && metadata.isChanging()) {
            changing = true;
        }
        if (identifier instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier id = (ModuleComponentIdentifier)identifier;
            if (identifier instanceof MavenUniqueSnapshotComponentIdentifier) {
                id = ((MavenUniqueSnapshotComponentIdentifier)id).getSnapshotComponent();
            }
            if (!id.getVersion().isEmpty() && this.allResolvedModules.add(id)) {
                String displayName;
                if (changing) {
                    this.addChangingModule(id);
                }
                if (this.dependencyLockingState.mustValidateLockState() && !this.lockingConstraints.remove(displayName = id.getDisplayName())) {
                    this.extraModules.add(displayName);
                }
            }
        }
    }

    private void addChangingModule(ModuleComponentIdentifier id) {
        if (this.changingResolvedModules == null) {
            this.changingResolvedModules = new HashSet<ModuleComponentIdentifier>();
        }
        this.changingResolvedModules.add(id);
    }

    @Override
    public void visitArtifacts(DependencyGraphNode from, DependencyGraphNode to, int artifactSetId, ArtifactSet artifacts) {
    }

    @Override
    public void visitArtifacts(DependencyGraphNode from, LocalFileDependencyMetadata fileDependency, int artifactSetId, ArtifactSet artifactSet) {
    }

    @Override
    public void finishArtifacts() {
        if (this.dependencyLockingState.mustValidateLockState()) {
            LOGGER.debug(" Dependency lock not matched '{}', extra resolved modules '{}'", this.lockingConstraints, this.extraModules);
            Set<String> notResolvedConstraints = Collections.emptySet();
            if (!this.lockingConstraints.isEmpty()) {
                notResolvedConstraints = new TreeSet<String>(this.lockingConstraints);
            }
            if (!notResolvedConstraints.isEmpty() || !this.extraModules.isEmpty()) {
                this.throwLockOutOfDateException(notResolvedConstraints, this.extraModules);
            }
        }
    }

    private void throwLockOutOfDateException(Set<String> notResolvedConstraints, Set<String> extraModules) {
        ArrayList errors = Lists.newArrayListWithCapacity((int)(notResolvedConstraints.size() + extraModules.size()));
        for (String notResolvedConstraint : notResolvedConstraints) {
            errors.add("Did not resolve '" + notResolvedConstraint + "' which is part of the lock state");
        }
        for (String extraModule : extraModules) {
            errors.add("Resolved '" + extraModule + "' which is not part of the lock state");
        }
        throw LockOutOfDateException.createLockOutOfDateException(this.configurationName, errors);
    }

    public void complete() {
        Set<ModuleComponentIdentifier> changingModules = this.changingResolvedModules == null ? Collections.emptySet() : this.changingResolvedModules;
        this.dependencyLockingProvider.persistResolvedDependencies(this.configurationName, this.allResolvedModules, changingModules);
    }
}

