/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.invocation;

import java.util.Collections;
import java.util.concurrent.Callable;
import org.gradle.api.internal.GradleInternal;
import org.gradle.initialization.GradleLauncher;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.work.WorkerLeaseService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradleBuildController
implements BuildController {
    private State state = State.Created;
    private boolean hasResult;
    private Object result;
    private final GradleLauncher gradleLauncher;
    private final WorkerLeaseService workerLeaseService;

    public GradleBuildController(GradleLauncher gradleLauncher, WorkerLeaseService workerLeaseService) {
        this.gradleLauncher = gradleLauncher;
        this.workerLeaseService = workerLeaseService;
    }

    public GradleBuildController(GradleLauncher gradleLauncher) {
        this(gradleLauncher, gradleLauncher.getGradle().getServices().get(WorkerLeaseService.class));
    }

    public GradleLauncher getLauncher() {
        if (this.state == State.Completed) {
            throw new IllegalStateException("Cannot use launcher after build has completed.");
        }
        return this.gradleLauncher;
    }

    @Override
    public boolean hasResult() {
        return this.hasResult;
    }

    @Override
    public Object getResult() {
        if (!this.hasResult) {
            throw new IllegalStateException("No result has been provided for this build action.");
        }
        return this.result;
    }

    @Override
    public void setResult(Object result) {
        this.hasResult = true;
        this.result = result;
    }

    @Override
    public GradleInternal getGradle() {
        return this.getLauncher().getGradle();
    }

    @Override
    public GradleInternal run() {
        return this.doBuild(new Callable<GradleInternal>(){

            @Override
            public GradleInternal call() {
                return GradleBuildController.this.getLauncher().executeTasks();
            }
        });
    }

    @Override
    public GradleInternal configure() {
        return this.doBuild(new Callable<GradleInternal>(){

            @Override
            public GradleInternal call() throws Exception {
                GradleInternal gradle = GradleBuildController.this.getLauncher().getConfiguredBuild();
                GradleBuildController.this.getLauncher().finishBuild();
                return gradle;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GradleInternal doBuild(Callable<GradleInternal> build) {
        try {
            GradleInternal gradleInternal = this.workerLeaseService.withLocks(Collections.singleton(this.workerLeaseService.getWorkerLease()), build);
            return gradleInternal;
        }
        finally {
            this.state = State.Completed;
        }
    }

    @Override
    public void stop() {
        this.gradleLauncher.stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        Created,
        Completed;

    }
}

