/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.hash;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.internal.file.FileMetadataSnapshot;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;

public class DefaultFileHasher
implements FileHasher {
    private final StreamHasher streamHasher;

    public DefaultFileHasher(StreamHasher streamHasher) {
        this.streamHasher = streamHasher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashCode hash(File file) {
        HashCode hashCode;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            hashCode = this.streamHasher.hash(inputStream);
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)inputStream);
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException(String.format("Failed to create MD5 hash for file '%s' as it does not exist.", file), e);
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return hashCode;
    }

    public HashCode hash(File file, FileMetadataSnapshot fileDetails) {
        return this.hash(file);
    }

    public HashCode hash(FileTreeElement fileDetails) {
        return this.hash(fileDetails.getFile());
    }
}

