/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.dispatch;

import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.AsyncStoppable;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.operations.CurrentBuildOperationPreservingRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncDispatch<T>
implements Dispatch<T>,
AsyncStoppable {
    private static final int MAX_QUEUE_SIZE = 200;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final LinkedList<T> queue = new LinkedList();
    private final Executor executor;
    private final int maxQueueSize;
    private int dispatchers;
    private State state;

    public AsyncDispatch(Executor executor) {
        this(executor, null, 200);
    }

    public AsyncDispatch(Executor executor, Dispatch<? super T> dispatch) {
        this(executor, dispatch, 200);
    }

    public AsyncDispatch(Executor executor, Dispatch<? super T> dispatch, int maxQueueSize) {
        this.executor = executor;
        this.maxQueueSize = maxQueueSize;
        this.state = State.Init;
        if (dispatch != null) {
            this.dispatchTo(dispatch);
        }
    }

    public void dispatchTo(final Dispatch<? super T> dispatch) {
        this.onDispatchThreadStart();
        this.executor.execute(new CurrentBuildOperationPreservingRunnable(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    AsyncDispatch.this.dispatchMessages(dispatch);
                }
                finally {
                    AsyncDispatch.this.onDispatchThreadExit();
                }
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDispatchThreadStart() {
        this.lock.lock();
        try {
            if (this.state != State.Init) {
                throw new IllegalStateException("This dispatch has been stopped.");
            }
            ++this.dispatchers;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDispatchThreadExit() {
        this.lock.lock();
        try {
            --this.dispatchers;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void setState(State state) {
        this.state = state;
        this.condition.signalAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchMessages(Dispatch<? super T> dispatch) {
        while (true) {
            Object message = null;
            this.lock.lock();
            try {
                while (this.state != State.Stopped && this.queue.isEmpty()) {
                    try {
                        this.condition.await();
                    }
                    catch (InterruptedException e) {
                        throw new UncheckedException(e);
                    }
                }
                if (!this.queue.isEmpty()) {
                    message = this.queue.remove();
                    this.condition.signalAll();
                }
            }
            finally {
                this.lock.unlock();
            }
            if (message == null) {
                return;
            }
            dispatch.dispatch(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(T message) {
        this.lock.lock();
        try {
            while (this.state != State.Stopped && this.queue.size() >= this.maxQueueSize) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw new UncheckedException(e);
                }
            }
            if (this.state == State.Stopped) {
                throw new IllegalStateException("Cannot dispatch message, as this message dispatch has been stopped. Message: " + message);
            }
            this.queue.add(message);
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestStop() {
        this.lock.lock();
        try {
            this.doRequestStop();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doRequestStop() {
        this.setState(State.Stopped);
    }

    @Override
    public void stop() {
        this.lock.lock();
        try {
            this.setState(State.Stopped);
            while (this.dispatchers > 0) {
                this.condition.await();
            }
            if (!this.queue.isEmpty()) {
                throw new IllegalStateException("Cannot wait for messages to be dispatched, as there are no dispatch threads running.");
            }
        }
        catch (InterruptedException e) {
            throw new UncheckedException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        Init,
        Stopped;

    }
}

