/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import org.gradle.api.Project;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.internal.artifacts.DefaultProjectComponentIdentifier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.initialization.BuildIdentity;
import org.gradle.util.Path;

public class DefaultProjectComponentSelector
implements ProjectComponentSelector {
    private final BuildIdentifier buildIdentifier;
    private final Path projectPath;
    private final Path identityPath;
    private final String projectName;
    private String displayName;

    public DefaultProjectComponentSelector(BuildIdentifier buildIdentifier, Path identityPath, Path projectPath, String projectName) {
        assert (buildIdentifier != null) : "build cannot be null";
        assert (identityPath != null) : "identity path cannot be null";
        assert (projectPath != null) : "project path cannot be null";
        assert (projectName != null) : "project name cannot be null";
        this.buildIdentifier = buildIdentifier;
        this.identityPath = identityPath;
        this.projectPath = projectPath;
        this.projectName = projectName;
    }

    @Override
    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = "project " + this.identityPath;
        }
        return this.displayName;
    }

    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    @Override
    public String getBuildName() {
        return this.buildIdentifier.getName();
    }

    public Path getIdentityPath() {
        return this.identityPath;
    }

    @Override
    public String getProjectPath() {
        return this.projectPath.getPath();
    }

    public Path projectPath() {
        return this.projectPath;
    }

    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public boolean matchesStrictly(ComponentIdentifier identifier) {
        assert (identifier != null) : "identifier cannot be null";
        if (identifier instanceof DefaultProjectComponentIdentifier) {
            DefaultProjectComponentIdentifier projectComponentIdentifier = (DefaultProjectComponentIdentifier)identifier;
            return projectComponentIdentifier.getIdentityPath().equals(this.identityPath);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultProjectComponentSelector)) {
            return false;
        }
        DefaultProjectComponentSelector that = (DefaultProjectComponentSelector)o;
        return this.identityPath.equals(that.identityPath);
    }

    public int hashCode() {
        return this.identityPath.hashCode();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static ProjectComponentSelector newSelector(Project project) {
        ProjectInternal projectInternal = (ProjectInternal)project;
        BuildIdentity buildIdentity = projectInternal.getServices().get(BuildIdentity.class);
        return new DefaultProjectComponentSelector(buildIdentity.getCurrentBuild(), projectInternal.getIdentityPath(), projectInternal.getProjectPath(), project.getName());
    }

    public static ProjectComponentSelector newSelector(ProjectComponentIdentifier identifier) {
        DefaultProjectComponentIdentifier projectComponentIdentifier = (DefaultProjectComponentIdentifier)identifier;
        return new DefaultProjectComponentSelector(projectComponentIdentifier.getBuild(), projectComponentIdentifier.getIdentityPath(), projectComponentIdentifier.projectPath(), projectComponentIdentifier.getProjectName());
    }

    public ProjectComponentIdentifier toIdentifier() {
        return new DefaultProjectComponentIdentifier(this.buildIdentifier, this.identityPath, this.projectPath, this.projectName);
    }
}

