/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.impldep.com.google.common.base.Objects;

public class DefaultModuleComponentSelector
implements ModuleComponentSelector {
    private final String group;
    private final String module;
    private final ImmutableVersionConstraint versionConstraint;
    private final ImmutableAttributes attributes;
    private final int hashCode;

    private DefaultModuleComponentSelector(String group, String module, ImmutableVersionConstraint version, ImmutableAttributes attributes) {
        assert (group != null) : "group cannot be null";
        assert (module != null) : "module cannot be null";
        assert (version != null) : "version cannot be null";
        assert (attributes != null) : "attributes cannot be null";
        this.group = group;
        this.module = module;
        this.versionConstraint = version;
        this.attributes = attributes;
        this.hashCode = Objects.hashCode((Object[])new Object[]{version, module, attributes, group});
    }

    @Override
    public String getDisplayName() {
        StringBuilder builder = new StringBuilder(this.group.length() + this.module.length() + this.versionConstraint.getPreferredVersion().length() + 2);
        builder.append(this.group);
        builder.append(":");
        builder.append(this.module);
        if (this.versionConstraint.getPreferredVersion().length() > 0) {
            builder.append(":");
            builder.append(this.versionConstraint.getPreferredVersion());
        }
        if (this.versionConstraint.getBranch() != null) {
            builder.append(" (branch: ");
            builder.append(this.versionConstraint.getBranch());
            builder.append(")");
        }
        return builder.toString();
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getModule() {
        return this.module;
    }

    @Override
    public String getVersion() {
        return this.versionConstraint.getPreferredVersion();
    }

    @Override
    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    @Override
    public AttributeContainer getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean matchesStrictly(ComponentIdentifier identifier) {
        assert (identifier != null) : "identifier cannot be null";
        if (identifier instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier moduleComponentIdentifier = (ModuleComponentIdentifier)identifier;
            return this.module.equals(moduleComponentIdentifier.getModule()) && this.group.equals(moduleComponentIdentifier.getGroup()) && this.versionConstraint.getPreferredVersion().equals(moduleComponentIdentifier.getVersion());
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultModuleComponentSelector that = (DefaultModuleComponentSelector)o;
        if (!this.group.equals(that.group)) {
            return false;
        }
        if (!this.module.equals(that.module)) {
            return false;
        }
        if (!this.versionConstraint.equals(that.versionConstraint)) {
            return false;
        }
        return this.attributes.equals(that.attributes);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static ModuleComponentSelector newSelector(String group, String name, VersionConstraint version, AttributeContainer attributes) {
        return new DefaultModuleComponentSelector(group, name, DefaultImmutableVersionConstraint.of(version), ((AttributeContainerInternal)attributes).asImmutable());
    }

    public static ModuleComponentSelector newSelector(String group, String name, VersionConstraint version) {
        return new DefaultModuleComponentSelector(group, name, DefaultImmutableVersionConstraint.of(version), ImmutableAttributes.EMPTY);
    }

    public static ModuleComponentSelector newSelector(String group, String name, String version) {
        return new DefaultModuleComponentSelector(group, name, DefaultImmutableVersionConstraint.of(version), ImmutableAttributes.EMPTY);
    }

    public static ModuleComponentSelector newSelector(ModuleVersionSelector selector) {
        return new DefaultModuleComponentSelector(selector.getGroup(), selector.getName(), DefaultImmutableVersionConstraint.of(selector.getVersion()), ImmutableAttributes.EMPTY);
    }
}

