/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classloader.ClassLoaderHasher;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.classloader.ClassLoaderVisitor;
import org.gradle.internal.classloader.MultiParentClassLoader;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.impldep.com.google.common.base.Charsets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableClassLoaderHierarchyHasher
implements ClassLoaderHierarchyHasher {
    private final Map<ClassLoader, byte[]> knownClassLoaders;
    private final ClassLoaderHasher classLoaderHasher;

    public ConfigurableClassLoaderHierarchyHasher(Map<ClassLoader, String> knownClassLoaders, ClassLoaderHasher classLoaderHasher) {
        this.classLoaderHasher = classLoaderHasher;
        WeakHashMap<ClassLoader, byte[]> hashes = new WeakHashMap<ClassLoader, byte[]>();
        for (Map.Entry<ClassLoader, String> entry : knownClassLoaders.entrySet()) {
            hashes.put(entry.getKey(), entry.getValue().getBytes(Charsets.UTF_8));
        }
        this.knownClassLoaders = hashes;
    }

    @Override
    @Nullable
    public HashCode getClassLoaderHash(ClassLoader classLoader) {
        Visitor visitor = new Visitor();
        visitor.visit(classLoader);
        return visitor.getHash();
    }

    private class Visitor
    extends ClassLoaderVisitor {
        private final Hasher hasher = Hashing.md5().newHasher();
        private boolean foundUnknown;

        private Visitor() {
        }

        public void visit(ClassLoader classLoader) {
            if (this.addToHash(classLoader)) {
                super.visit(classLoader);
            }
        }

        public HashCode getHash() {
            return this.foundUnknown ? null : this.hasher.hash();
        }

        private boolean addToHash(ClassLoader cl) {
            byte[] knownId = (byte[])ConfigurableClassLoaderHierarchyHasher.this.knownClassLoaders.get(cl);
            if (knownId != null) {
                this.hasher.putBytes(knownId);
                return false;
            }
            if (cl instanceof CachingClassLoader || cl instanceof MultiParentClassLoader) {
                return true;
            }
            HashCode hash = ConfigurableClassLoaderHierarchyHasher.this.classLoaderHasher.getHash(cl);
            if (hash != null) {
                this.hasher.putHash(hash);
                return true;
            }
            this.foundUnknown = true;
            return false;
        }
    }
}

