/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.internal.xcodeproj;

import java.util.Map;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMultimap;

public enum FileTypes {
    MACH_O_EXECUTABLE("", "compiled.mach-o.executable"),
    MACH_O_DYNAMIC_LIBRARY("dylib", "compiled.mach-o.dylib"),
    ARCHIVE_LIBRARY("a", "archive.ar"),
    C_SOURCE_CODE("c", "sourcecode.c.c"),
    CC_SOURCE_CODE("cc", "sourcecode.cpp.cpp"),
    CPP_SOURCE_CODE("cpp", "sourcecode.cpp.cpp"),
    CXX_SOURCE_CODE("cxx", "sourcecode.cpp.cpp"),
    H_SOURCE_CODE("h", "sourcecode.c.h"),
    SWIFT_SOURCE_CODE("swift", "sourcecode.swift"),
    XCODE_PROJECT_WRAPPER("xcodeproj", "wrapper.pb-project");

    public final String fileExtension;
    public final String identifier;
    public static final ImmutableMap<String, String> FILE_EXTENSION_TO_UTI;
    public static final ImmutableMultimap<String, String> UTI_TO_FILE_EXTENSIONS;

    private FileTypes(String fileExtension, String identifier) {
        this.fileExtension = fileExtension;
        this.identifier = identifier;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (FileTypes fileType : FileTypes.values()) {
            builder.put((Object)fileType.fileExtension, (Object)fileType.identifier);
        }
        FILE_EXTENSION_TO_UTI = builder.build();
        builder = ImmutableMultimap.builder();
        for (Map.Entry entry : FILE_EXTENSION_TO_UTI.entrySet()) {
            builder.put(entry.getValue(), entry.getKey());
        }
        UTI_TO_FILE_EXTENSIONS = builder.build();
    }
}

