/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.internal;

import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Named;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.ide.xcode.internal.xcodeproj.FileTypes;
import org.gradle.ide.xcode.internal.xcodeproj.PBXTarget;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.language.swift.SwiftVersion;

public class XcodeTarget
implements Named {
    private final String id;
    private final String name;
    private final ConfigurableFileCollection headerSearchPaths;
    private final ConfigurableFileCollection compileModules;
    private final ConfigurableFileCollection sources;
    private final List<TaskDependency> taskDependencies = Lists.newArrayList();
    private String taskName;
    private String gradleCommand;
    private Provider<? extends FileSystemLocation> debugOutputFile;
    private Provider<? extends FileSystemLocation> releaseOutputFile;
    private PBXTarget.ProductType productType;
    private String productName;
    private String outputFileType;
    private Property<SwiftVersion> swiftSourceCompatibility;

    @Inject
    public XcodeTarget(String name, String id, FileOperations fileOperations, ObjectFactory objectFactory) {
        this.name = name;
        this.id = id;
        this.sources = fileOperations.files(new Object[0]);
        this.headerSearchPaths = fileOperations.files(new Object[0]);
        this.compileModules = fileOperations.files(new Object[0]);
        this.swiftSourceCompatibility = objectFactory.property(SwiftVersion.class);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Provider<? extends FileSystemLocation> getDebugOutputFile() {
        return this.debugOutputFile;
    }

    public Provider<? extends FileSystemLocation> getReleaseOutputFile() {
        return this.releaseOutputFile;
    }

    public String getOutputFileType() {
        return this.outputFileType;
    }

    public void setOutputFileType(String outputFileType) {
        this.outputFileType = outputFileType;
    }

    public PBXTarget.ProductType getProductType() {
        return this.productType;
    }

    public void setProductType(PBXTarget.ProductType productType) {
        this.productType = productType;
    }

    public boolean isRunnable() {
        return PBXTarget.ProductType.TOOL.equals((Object)this.getProductType());
    }

    public boolean isUnitTest() {
        return PBXTarget.ProductType.UNIT_TEST.equals((Object)this.getProductType());
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getGradleCommand() {
        return this.gradleCommand;
    }

    public void setGradleCommand(String gradleCommand) {
        this.gradleCommand = gradleCommand;
    }

    public ConfigurableFileCollection getSources() {
        return this.sources;
    }

    public ConfigurableFileCollection getHeaderSearchPaths() {
        return this.headerSearchPaths;
    }

    public ConfigurableFileCollection getCompileModules() {
        return this.compileModules;
    }

    public void addTaskDependency(TaskDependency taskDependency) {
        this.taskDependencies.add(taskDependency);
    }

    public List<TaskDependency> getTaskDependencies() {
        return this.taskDependencies;
    }

    public void setDebug(Provider<? extends FileSystemLocation> debugProductLocation, PBXTarget.ProductType productType) {
        this.debugOutputFile = debugProductLocation;
        this.productType = productType;
        this.outputFileType = XcodeTarget.toFileType(productType);
    }

    public void setRelease(Provider<? extends FileSystemLocation> releaseProductLocation, PBXTarget.ProductType productType) {
        this.releaseOutputFile = releaseProductLocation;
        this.productType = productType;
        this.outputFileType = XcodeTarget.toFileType(productType);
    }

    private static String toFileType(PBXTarget.ProductType productType) {
        if (PBXTarget.ProductType.TOOL.equals((Object)productType)) {
            return FileTypes.MACH_O_EXECUTABLE.identifier;
        }
        if (PBXTarget.ProductType.DYNAMIC_LIBRARY.equals((Object)productType)) {
            return FileTypes.MACH_O_DYNAMIC_LIBRARY.identifier;
        }
        if (PBXTarget.ProductType.STATIC_LIBRARY.equals((Object)productType)) {
            return FileTypes.ARCHIVE_LIBRARY.identifier;
        }
        return "compiled";
    }

    public Property<SwiftVersion> getSwiftSourceCompatibility() {
        return this.swiftSourceCompatibility;
    }
}

