/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.Action;
import org.gradle.execution.CancellableOperationManager;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.UncheckedException;
import org.gradle.util.DisconnectableInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCancellableOperationManager
implements CancellableOperationManager {
    private static final int EOF = -1;
    private static final int KEY_CODE_CTRL_D = 4;
    private final ExecutorService executorService;
    private final DisconnectableInputStream input;
    private final BuildCancellationToken cancellationToken;

    public DefaultCancellableOperationManager(ExecutorService executorService, DisconnectableInputStream input, BuildCancellationToken cancellationToken) {
        this.executorService = executorService;
        this.input = input;
        this.cancellationToken = cancellationToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitorInput(Action<? super BuildCancellationToken> operation) {
        final AtomicBoolean operationCompleted = new AtomicBoolean();
        Future<?> handle = null;
        try {
            handle = this.executorService.submit(new Runnable(){

                public void run() {
                    try {
                        while (!Thread.currentThread().isInterrupted()) {
                            int c = DefaultCancellableOperationManager.this.input.read();
                            if (!operationCompleted.get()) {
                                if (!DefaultCancellableOperationManager.isCancellation(c) || operationCompleted.get()) continue;
                                DefaultCancellableOperationManager.this.cancellationToken.cancel();
                            }
                            break;
                        }
                    }
                    catch (IOException e) {
                        throw UncheckedException.throwAsUncheckedException(e);
                    }
                }
            });
            operation.execute(this.cancellationToken);
            operationCompleted.set(true);
        }
        finally {
            if (handle != null) {
                handle.cancel(true);
            }
        }
    }

    @Override
    public void closeInput() {
        try {
            this.input.close();
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    private static boolean isCancellation(int c) {
        return c == 4 || c == -1;
    }
}

