/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration.project;

import org.gradle.api.Action;
import org.gradle.api.ProjectConfigurationException;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateInternal;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.configuration.project.ConfigureProjectBuildOperationType;
import org.gradle.configuration.project.ProjectEvaluator;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleProjectEvaluator
implements ProjectEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LifecycleProjectEvaluator.class);
    private final BuildOperationExecutor buildOperationExecutor;
    private final ProjectEvaluator delegate;

    public LifecycleProjectEvaluator(BuildOperationExecutor buildOperationExecutor, ProjectEvaluator delegate) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.delegate = delegate;
    }

    public void evaluate(ProjectInternal project, ProjectStateInternal state) {
        if (state.getExecuted() || state.getExecuting()) {
            return;
        }
        this.buildOperationExecutor.run(new ConfigureProject(project, state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConfigure(ProjectInternal project, ProjectStateInternal state) {
        ProjectEvaluationListener listener = project.getProjectEvaluationBroadcaster();
        try {
            listener.beforeEvaluate(project);
        }
        catch (Exception e) {
            this.addConfigurationFailure(project, state, e);
            return;
        }
        state.setExecuting(true);
        try {
            this.delegate.evaluate(project, state);
        }
        catch (Exception e) {
            this.addConfigurationFailure(project, state, e);
        }
        finally {
            state.setExecuting(false);
            state.executed();
            this.notifyAfterEvaluate(listener, project, state);
        }
    }

    private void notifyAfterEvaluate(ProjectEvaluationListener firstBatch, final ProjectInternal project, final ProjectStateInternal state) {
        ProjectEvaluationListener nextBatch = firstBatch;
        do {
            try {
                nextBatch = project.stepEvaluationListener(nextBatch, new Action<ProjectEvaluationListener>(){

                    @Override
                    public void execute(ProjectEvaluationListener listener) {
                        listener.afterEvaluate(project, state);
                    }
                });
            }
            catch (Exception e) {
                this.onAfterEvaluateFailure(e, project, state);
                return;
            }
        } while (nextBatch != null);
    }

    private void onAfterEvaluateFailure(Exception e, ProjectInternal project, ProjectStateInternal state) {
        if (state.hasFailure()) {
            boolean logStackTraces = project.getGradle().getStartParameter().getShowStacktrace() != ShowStacktrace.INTERNAL_EXCEPTIONS;
            String infoMessage = "Project evaluation failed including an error in afterEvaluate {}.";
            if (logStackTraces) {
                LOGGER.error(infoMessage, (Throwable)e);
            } else {
                LOGGER.error(infoMessage + " Run with --stacktrace for details of the afterEvaluate {} error.");
            }
            return;
        }
        this.addConfigurationFailure(project, state, e);
    }

    private void addConfigurationFailure(ProjectInternal project, ProjectStateInternal state, Exception e) {
        ProjectConfigurationException failure = new ProjectConfigurationException(String.format("A problem occurred configuring %s.", project.getDisplayName()), e);
        state.executed(failure);
    }

    private class ConfigureProject
    implements RunnableBuildOperation {
        private ProjectInternal project;
        private ProjectStateInternal state;

        private ConfigureProject(ProjectInternal project, ProjectStateInternal state) {
            this.project = project;
            this.state = state;
        }

        public void run(BuildOperationContext context) {
            LifecycleProjectEvaluator.this.doConfigure(this.project, this.state);
            this.state.rethrowFailure();
            context.setResult(ConfigureProjectBuildOperationType.RESULT);
        }

        public BuildOperationDescriptor.Builder description() {
            String name = "Configure project " + this.project.getIdentityPath();
            return BuildOperationDescriptor.displayName(name).operationType(BuildOperationCategory.CONFIGURE_PROJECT).details(new ConfigureProjectBuildOperationType.DetailsImpl(this.project.getProjectPath(), this.project.getGradle().getIdentityPath()));
        }
    }
}

