/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import org.gradle.BuildAdapter;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.invocation.Gradle;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.initialization.RunNestedBuildBuildOperationType;
import org.gradle.internal.build.AbstractBuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.StandAloneNestedBuild;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.invocation.GradleBuildController;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.util.Path;

public class RootOfNestedBuildTree
extends AbstractBuildState
implements StandAloneNestedBuild {
    private final BuildIdentifier buildIdentifier;
    private final GradleLauncher gradleLauncher;

    public RootOfNestedBuildTree(BuildDefinition buildDefinition, BuildIdentifier buildIdentifier, NestedBuildFactory buildFactory) {
        this.buildIdentifier = buildIdentifier;
        this.gradleLauncher = buildFactory.nestedBuildTree(buildDefinition, buildIdentifier);
    }

    @Override
    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    @Override
    public boolean isImplicitBuild() {
        return false;
    }

    @Override
    public SettingsInternal getLoadedSettings() {
        return this.gradleLauncher.getGradle().getSettings();
    }

    @Override
    public Path getIdentityPathForProject(Path projectPath) {
        return this.gradleLauncher.getGradle().getIdentityPath().append(projectPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(final Transformer<T, ? super BuildController> buildAction) {
        final GradleBuildController buildController = new GradleBuildController(this.gradleLauncher);
        try {
            final GradleInternal gradle = this.gradleLauncher.getGradle();
            gradle.getServices().get(BuildStateRegistry.class).register(this);
            BuildOperationExecutor executor = gradle.getServices().get(BuildOperationExecutor.class);
            Object t = executor.call(new CallableBuildOperation<T>(){

                @Override
                public T call(BuildOperationContext context) {
                    gradle.addBuildListener(new BuildAdapter(){

                        @Override
                        public void projectsLoaded(Gradle g) {
                            gradle.getServices().get(ProjectStateRegistry.class).registerProjects(RootOfNestedBuildTree.this);
                        }
                    });
                    Object result = buildAction.transform(buildController);
                    context.setResult(new RunNestedBuildBuildOperationType.Result(){});
                    return result;
                }

                @Override
                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName("Run nested build").details(new RunNestedBuildBuildOperationType.Details(){

                        @Override
                        public String getBuildPath() {
                            return gradle.getIdentityPath().getPath();
                        }
                    });
                }
            });
            return t;
        }
        finally {
            buildController.stop();
        }
    }
}

