/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.composite.internal.CompositeProjectComponentArtifactMetadata;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class IncludedBuildDependencyMetadataBuilder {
    public LocalComponentMetadata build(IncludedBuildState build, ProjectComponentIdentifier projectIdentifier) {
        GradleInternal gradle = build.getConfiguredBuild();
        LocalComponentRegistry localComponentRegistry = gradle.getServices().get(LocalComponentRegistry.class);
        DefaultLocalComponentMetadata originalComponent = (DefaultLocalComponentMetadata)localComponentRegistry.getComponent(projectIdentifier);
        ProjectComponentIdentifier foreignIdentifier = build.idToReferenceProjectFromAnotherBuild(projectIdentifier);
        return this.createCompositeCopy(foreignIdentifier, originalComponent);
    }

    private LocalComponentMetadata createCompositeCopy(final ProjectComponentIdentifier componentIdentifier, DefaultLocalComponentMetadata originalComponentMetadata) {
        return originalComponentMetadata.copy(componentIdentifier, new Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata>(){

            @Override
            public LocalComponentArtifactMetadata transform(LocalComponentArtifactMetadata originalArtifact) {
                File artifactFile = originalArtifact.getFile();
                Set targetTasks = IncludedBuildDependencyMetadataBuilder.this.getArtifactTasks(originalArtifact);
                return new CompositeProjectComponentArtifactMetadata(componentIdentifier, originalArtifact.getName(), artifactFile, targetTasks);
            }
        });
    }

    private Set<String> getArtifactTasks(ComponentArtifactMetadata artifactMetaData) {
        LinkedHashSet taskPaths = Sets.newLinkedHashSet();
        Set<? extends Task> tasks = artifactMetaData.getBuildDependencies().getDependencies(null);
        for (Task task : tasks) {
            taskPaths.add(task.getPath());
        }
        return taskPaths;
    }
}

