/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.composite.internal.BuildStateListener;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.internal.build.AbstractBuildState;
import org.gradle.internal.build.StandAloneNestedBuild;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.invocation.GradleBuildController;
import org.gradle.util.Path;

class DefaultNestedBuild
extends AbstractBuildState
implements StandAloneNestedBuild {
    private final BuildDefinition buildDefinition;
    private final NestedBuildFactory nestedBuildFactory;
    private final BuildStateListener buildStateListener;
    private final BuildIdentifier buildIdentifier;
    private SettingsInternal settings;

    DefaultNestedBuild(BuildIdentifier buildIdentifier, BuildDefinition buildDefinition, NestedBuildFactory nestedBuildFactory, BuildStateListener buildStateListener) {
        this.buildIdentifier = buildIdentifier;
        this.buildDefinition = buildDefinition;
        this.nestedBuildFactory = nestedBuildFactory;
        this.buildStateListener = buildStateListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(Transformer<T, ? super BuildController> buildAction) {
        GradleLauncher gradleLauncher = this.nestedBuildFactory.nestedInstance(this.buildDefinition, this);
        GradleBuildController buildController = new GradleBuildController(gradleLauncher);
        try {
            final GradleInternal gradle = buildController.getGradle();
            gradle.rootProject((Action<? super Project>)new Action<Project>(){

                @Override
                public void execute(Project rootProject) {
                    DefaultNestedBuild.this.settings = gradle.getSettings();
                    DefaultNestedBuild.this.buildStateListener.projectsKnown(DefaultNestedBuild.this);
                }
            });
            T t = buildAction.transform(buildController);
            return t;
        }
        finally {
            buildController.stop();
        }
    }

    @Override
    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    @Override
    public boolean isImplicitBuild() {
        return true;
    }

    @Override
    public SettingsInternal getLoadedSettings() {
        if (this.settings == null) {
            throw new IllegalStateException("Settings not loaded yet.");
        }
        return this.settings;
    }

    @Override
    public Path getIdentityPathForProject(Path projectPath) {
        return this.getLoadedSettings().getGradle().getRootProject().getProjectRegistry().getProject(projectPath.getPath()).getIdentityPath();
    }
}

