/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.initialization.ConfigurableIncludedBuild;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.artifacts.DefaultBuildIdentifier;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.composite.internal.BuildStateListener;
import org.gradle.composite.internal.DefaultNestedBuild;
import org.gradle.composite.internal.DefaultRootBuildState;
import org.gradle.composite.internal.IncludedBuildDependencySubstitutionsBuilder;
import org.gradle.composite.internal.IncludedBuildFactory;
import org.gradle.composite.internal.RootOfNestedBuildTree;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.build.StandAloneNestedBuild;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.service.ServiceRegistry;

public class DefaultIncludedBuildRegistry
implements BuildStateRegistry,
Stoppable {
    private final IncludedBuildFactory includedBuildFactory;
    private final ProjectStateRegistry projectRegistry;
    private final IncludedBuildDependencySubstitutionsBuilder dependencySubstitutionsBuilder;
    private final GradleLauncherFactory gradleLauncherFactory;
    private final ListenerManager listenerManager;
    private final ServiceRegistry rootServices;
    private DefaultRootBuildState rootBuild;
    private final Map<BuildIdentifier, BuildState> builds = Maps.newHashMap();
    private final Map<File, IncludedBuildState> includedBuilds = Maps.newLinkedHashMap();

    public DefaultIncludedBuildRegistry(IncludedBuildFactory includedBuildFactory, ProjectStateRegistry projectRegistry, IncludedBuildDependencySubstitutionsBuilder dependencySubstitutionsBuilder, GradleLauncherFactory gradleLauncherFactory, ListenerManager listenerManager, ServiceRegistry rootServices) {
        this.includedBuildFactory = includedBuildFactory;
        this.projectRegistry = projectRegistry;
        this.dependencySubstitutionsBuilder = dependencySubstitutionsBuilder;
        this.gradleLauncherFactory = gradleLauncherFactory;
        this.listenerManager = listenerManager;
        this.rootServices = rootServices;
    }

    @Override
    public RootBuildState addRootBuild(BuildDefinition buildDefinition, BuildRequestContext requestContext) {
        if (this.rootBuild != null) {
            throw new IllegalStateException("Root build already defined.");
        }
        this.rootBuild = new DefaultRootBuildState(buildDefinition, requestContext, this.gradleLauncherFactory, this.listenerManager, this.rootServices);
        this.addBuild(this.rootBuild);
        return this.rootBuild;
    }

    private void addBuild(BuildState build) {
        BuildState before = this.builds.put(build.getBuildIdentifier(), build);
        if (before != null) {
            throw new IllegalArgumentException("Build is already registered: " + build.getBuildIdentifier());
        }
    }

    public boolean hasIncludedBuilds() {
        return !this.includedBuilds.isEmpty();
    }

    public Collection<IncludedBuildState> getIncludedBuilds() {
        return this.includedBuilds.values();
    }

    @Override
    public IncludedBuildState addExplicitBuild(BuildDefinition buildDefinition, NestedBuildFactory nestedBuildFactory) {
        return this.registerBuild(buildDefinition, false, nestedBuildFactory);
    }

    @Override
    public IncludedBuildState getIncludedBuild(BuildIdentifier buildIdentifier) {
        BuildState includedBuildState = this.builds.get(buildIdentifier);
        if (!(includedBuildState instanceof IncludedBuildState)) {
            throw new IllegalArgumentException("Could not find " + buildIdentifier);
        }
        return (IncludedBuildState)includedBuildState;
    }

    @Override
    public BuildState getBuild(BuildIdentifier buildIdentifier) {
        BuildState buildState = this.builds.get(buildIdentifier);
        if (buildState == null) {
            throw new IllegalArgumentException("Could not find " + buildIdentifier);
        }
        return buildState;
    }

    @Override
    public void register(BuildState build) {
        this.addBuild(build);
    }

    @Override
    public void registerRootBuild(SettingsInternal settings) {
        this.validateIncludedBuilds(settings);
        this.rootBuild.setSettings(settings);
        this.projectRegistry.registerProjects(this.rootBuild);
        Collection<IncludedBuildState> includedBuilds = this.getIncludedBuilds();
        ArrayList<ConfigurableIncludedBuild> modelElements = new ArrayList<ConfigurableIncludedBuild>(includedBuilds.size());
        for (IncludedBuildState includedBuild : includedBuilds) {
            modelElements.add(includedBuild.getModel());
        }
        settings.getGradle().setIncludedBuilds(modelElements);
        this.registerProjects(includedBuilds);
    }

    @Override
    public void beforeConfigureRootBuild() {
        this.registerSubstitutions(this.includedBuilds.values());
    }

    private void registerProjects(Collection<IncludedBuildState> includedBuilds) {
        for (IncludedBuildState includedBuild : includedBuilds) {
            this.projectRegistry.registerProjects(includedBuild);
        }
    }

    private void validateIncludedBuilds(SettingsInternal settings) {
        HashSet names = Sets.newHashSet();
        for (IncludedBuildState build : this.includedBuilds.values()) {
            String buildName = build.getName();
            if (!names.add(buildName)) {
                throw new GradleException("Included build '" + buildName + "' is not unique in composite.");
            }
            if (settings.getRootProject().getName().equals(buildName)) {
                throw new GradleException("Included build '" + buildName + "' collides with root project name.");
            }
            if (settings.findProject(":" + buildName) == null) continue;
            throw new GradleException("Included build '" + buildName + "' collides with subproject of the same name.");
        }
    }

    private void registerSubstitutions(Iterable<IncludedBuildState> includedBuilds) {
        for (IncludedBuildState includedBuild : includedBuilds) {
            this.dependencySubstitutionsBuilder.build(includedBuild);
        }
    }

    @Override
    public IncludedBuildState addImplicitBuild(BuildDefinition buildDefinition, NestedBuildFactory nestedBuildFactory) {
        IncludedBuildState includedBuild = this.includedBuilds.get(buildDefinition.getBuildRootDir());
        if (includedBuild == null) {
            includedBuild = this.registerBuild(buildDefinition, true, nestedBuildFactory);
            this.projectRegistry.registerProjects(includedBuild);
        }
        return includedBuild;
    }

    @Override
    public StandAloneNestedBuild addNestedBuild(BuildDefinition buildDefinition, NestedBuildFactory nestedBuildFactory) {
        if (buildDefinition.getName() == null) {
            throw new UnsupportedOperationException("Not yet implemented.");
        }
        BuildIdentifier buildIdentifier = this.idFor(buildDefinition.getName());
        DefaultNestedBuild build = new DefaultNestedBuild(buildIdentifier, buildDefinition, nestedBuildFactory, new BuildStateListener(){

            @Override
            public void projectsKnown(BuildState build1) {
                DefaultIncludedBuildRegistry.this.projectRegistry.registerProjects(build1);
            }
        });
        this.addBuild(build);
        return build;
    }

    @Override
    public StandAloneNestedBuild addNestedBuildTree(BuildDefinition buildDefinition, NestedBuildFactory nestedBuildFactory) {
        if (buildDefinition.getName() != null || buildDefinition.getBuildRootDir() != null) {
            throw new UnsupportedOperationException("Not yet implemented.");
        }
        BuildIdentifier buildIdentifier = this.idFor(buildDefinition.getStartParameter().getCurrentDir().getName());
        return new RootOfNestedBuildTree(buildDefinition, buildIdentifier, nestedBuildFactory);
    }

    private IncludedBuildState registerBuild(BuildDefinition buildDefinition, boolean isImplicit, NestedBuildFactory nestedBuildFactory) {
        if (buildDefinition.getBuildRootDir() == null) {
            throw new IllegalArgumentException("Included build must have a root directory defined");
        }
        IncludedBuildState includedBuild = this.includedBuilds.get(buildDefinition.getBuildRootDir());
        if (includedBuild == null) {
            String buildName = buildDefinition.getBuildRootDir().getName();
            BuildIdentifier buildIdentifier = this.idFor(buildName);
            includedBuild = this.includedBuildFactory.createBuild(buildIdentifier, buildDefinition, isImplicit, nestedBuildFactory);
            this.includedBuilds.put(buildDefinition.getBuildRootDir(), includedBuild);
            this.addBuild(includedBuild);
        } else if (includedBuild.isImplicitBuild() != isImplicit) {
            throw new IllegalStateException("Unexpected state for build.");
        }
        return includedBuild;
    }

    private BuildIdentifier idFor(String buildName) {
        DefaultBuildIdentifier buildIdentifier = new DefaultBuildIdentifier(buildName);
        int count = 1;
        while (this.builds.containsKey(buildIdentifier)) {
            buildIdentifier = new DefaultBuildIdentifier(buildName + ":" + count);
            ++count;
        }
        return buildIdentifier;
    }

    @Override
    public void stop() {
        CompositeStoppable.stoppable(this.builds.values()).stop();
    }
}

