/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionAdapter;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.composite.internal.IncludedBuildController;
import org.gradle.initialization.ReportedException;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultIncludedBuildController
implements Runnable,
Stoppable,
IncludedBuildController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIncludedBuildController.class);
    private final IncludedBuildState includedBuild;
    private final Map<String, TaskState> tasks = Maps.newLinkedHashMap();
    private final Set<String> tasksAdded = Sets.newHashSet();
    private final Lock lock = new ReentrantLock();
    private final Condition taskQueued = this.lock.newCondition();
    private final Condition taskCompleted = this.lock.newCondition();
    private final CountDownLatch started = new CountDownLatch(1);
    private final AtomicBoolean stopRequested = new AtomicBoolean();
    private final CountDownLatch stopped = new CountDownLatch(1);

    public DefaultIncludedBuildController(IncludedBuildState includedBuild) {
        this.includedBuild = includedBuild;
    }

    @Override
    public boolean populateTaskGraph() {
        LinkedHashSet tasksToExecute = Sets.newLinkedHashSet();
        for (Map.Entry<String, TaskState> taskEntry : this.tasks.entrySet()) {
            String taskName;
            if (taskEntry.getValue().status != TaskStatus.QUEUED || !this.tasksAdded.add(taskName = taskEntry.getKey())) continue;
            tasksToExecute.add(taskName);
        }
        if (tasksToExecute.isEmpty()) {
            return false;
        }
        this.includedBuild.addTasks(tasksToExecute);
        return true;
    }

    @Override
    public void run() {
        try {
            this.started.await();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        while (!this.stopRequested.get()) {
            Set<String> tasksToExecute = this.getQueuedTasks();
            try {
                this.doBuild(tasksToExecute);
            }
            catch (ReportedException reportedException) {}
        }
        this.stopped.countDown();
    }

    @Override
    public void startTaskExecution() {
        this.started.countDown();
    }

    @Override
    public void stopTaskExecution() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.stopRequested.set(true);
        this.started.countDown();
        this.lock.lock();
        try {
            this.taskQueued.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        try {
            this.stopped.await();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<String> getQueuedTasks() {
        this.lock.lock();
        try {
            while (!this.stopRequested.get()) {
                LinkedHashSet tasksToExecute = Sets.newLinkedHashSet();
                for (Map.Entry<String, TaskState> taskEntry : this.tasks.entrySet()) {
                    if (taskEntry.getValue().status != TaskStatus.QUEUED) continue;
                    tasksToExecute.add(taskEntry.getKey());
                    taskEntry.getValue().status = TaskStatus.EXECUTING;
                }
                if (!tasksToExecute.isEmpty()) {
                    LinkedHashSet i$ = tasksToExecute;
                    return i$;
                }
                try {
                    this.taskQueued.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                    return Collections.emptySet();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doBuild(Collection<String> tasksToExecute) {
        if (tasksToExecute.isEmpty()) {
            return;
        }
        LOGGER.info("Executing " + this.includedBuild.getName() + " tasks " + tasksToExecute);
        IncludedBuildExecutionListener listener = new IncludedBuildExecutionListener(tasksToExecute);
        this.includedBuild.execute(tasksToExecute, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void taskCompleted(String task, Throwable failure) {
        this.lock.lock();
        try {
            TaskState taskState = this.tasks.get(task);
            taskState.status = failure == null ? TaskStatus.SUCCESS : TaskStatus.FAILED;
            taskState.failure = failure;
            this.taskCompleted.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildFailed(Collection<String> tasksExecuted, Throwable failure) {
        this.lock.lock();
        try {
            for (String task : tasksExecuted) {
                TaskState taskState = this.tasks.get(task);
                if (taskState.status != TaskStatus.EXECUTING) continue;
                taskState.status = TaskStatus.FAILED;
                taskState.failure = failure;
            }
            this.taskCompleted.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueForExecution(String taskPath) {
        this.lock.lock();
        try {
            if (!this.tasks.containsKey(taskPath)) {
                this.tasks.put(taskPath, new TaskState());
                this.taskQueued.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void awaitCompletion(String taskPath) {
        this.lock.lock();
        try {
            while (!this.isComplete(taskPath)) {
                this.taskCompleted.await();
            }
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isComplete(String taskPath) {
        this.lock.lock();
        try {
            TaskState state = this.tasks.get(taskPath);
            if (state == null) {
                throw new IllegalStateException("Included build task '" + taskPath + "' was never scheduled for execution.");
            }
            if (state.status == TaskStatus.FAILED) {
                throw UncheckedException.throwAsUncheckedException(state.failure);
            }
            boolean bl = state.status == TaskStatus.SUCCESS;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private class IncludedBuildExecutionListener
    extends BuildAdapter
    implements TaskExecutionGraphListener,
    BuildListener {
        private final Collection<String> tasksToExecute;

        public IncludedBuildExecutionListener(Collection<String> tasksToExecute) {
            this.tasksToExecute = tasksToExecute;
        }

        @Override
        public void graphPopulated(TaskExecutionGraph taskExecutionGraph) {
            for (String task : this.tasksToExecute) {
                if (taskExecutionGraph.hasTask(task)) continue;
                throw new GradleException("Task '" + task + "' not found in build '" + DefaultIncludedBuildController.this.includedBuild.getName() + "'.");
            }
            taskExecutionGraph.addTaskExecutionListener(new TaskCompletionRecorder());
        }

        @Override
        public void buildFinished(BuildResult result) {
            if (result.getFailure() != null) {
                DefaultIncludedBuildController.this.buildFailed(this.tasksToExecute, result.getFailure());
            }
        }

        private class TaskCompletionRecorder
        extends TaskExecutionAdapter {
            private TaskCompletionRecorder() {
            }

            @Override
            public void afterExecute(Task task, org.gradle.api.tasks.TaskState state) {
                String taskPath = task.getPath();
                if (IncludedBuildExecutionListener.this.tasksToExecute.contains(taskPath)) {
                    Throwable failure = state.getFailure();
                    DefaultIncludedBuildController.this.taskCompleted(taskPath, failure);
                }
            }
        }
    }

    private static class TaskState {
        public BuildResult result;
        public Throwable failure;
        public TaskStatus status = TaskStatus.QUEUED;

        private TaskState() {
        }

        public void rethrowFailure() {
            if (this.failure != null) {
                throw UncheckedException.throwAsUncheckedException(this.failure);
            }
        }
    }

    private static enum TaskStatus {
        QUEUED,
        EXECUTING,
        FAILED,
        SUCCESS;

    }
}

