/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.initialization.ConfigurableIncludedBuild;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.artifacts.DefaultProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ForeignBuildIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.TaskReference;
import org.gradle.composite.internal.IncludedBuildTaskReference;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.internal.Pair;
import org.gradle.internal.build.AbstractBuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetadata;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIncludedBuild
extends AbstractBuildState
implements IncludedBuildState,
ConfigurableIncludedBuild,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIncludedBuild.class);
    private final BuildIdentifier buildIdentifier;
    private final BuildDefinition buildDefinition;
    private final boolean isImplicit;
    private final NestedBuildFactory gradleLauncherFactory;
    private final WorkerLeaseRegistry.WorkerLease parentLease;
    private final List<Action<? super DependencySubstitutions>> dependencySubstitutionActions = Lists.newArrayList();
    private boolean resolvedDependencySubstitutions;
    private GradleLauncher gradleLauncher;
    private boolean discardLauncher;
    private String name;
    private Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> availableModules;

    public DefaultIncludedBuild(BuildIdentifier buildIdentifier, BuildDefinition buildDefinition, boolean isImplicit, NestedBuildFactory launcherFactory, WorkerLeaseRegistry.WorkerLease parentLease) {
        this.buildIdentifier = buildIdentifier;
        this.buildDefinition = buildDefinition;
        this.isImplicit = isImplicit;
        this.gradleLauncherFactory = launcherFactory;
        this.parentLease = parentLease;
    }

    @Override
    public boolean isImplicitBuild() {
        return this.isImplicit;
    }

    @Override
    public ConfigurableIncludedBuild getModel() {
        return this;
    }

    @Override
    public File getProjectDir() {
        return this.buildDefinition.getBuildRootDir();
    }

    @Override
    public TaskReference task(String path) {
        Preconditions.checkArgument((boolean)path.startsWith(":"), (String)"Task path '%s' is not a qualified task path (e.g. ':task' or ':project:task').", (Object[])new Object[]{path});
        return new IncludedBuildTaskReference(this.getBuildIdentifier(), path);
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.getLoadedSettings().getRootProject().getName();
        }
        return this.name;
    }

    @Override
    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    @Override
    public Path getIdentityPathForProject(Path projectPath) {
        GradleInternal parentBuild = this.getLoadedSettings().getGradle().getParent();
        Path rootPath = parentBuild == null ? Path.ROOT.child(this.getName()) : parentBuild.getIdentityPath().child(this.getName());
        return rootPath.append(projectPath);
    }

    @Override
    public void dependencySubstitution(Action<? super DependencySubstitutions> action) {
        if (this.resolvedDependencySubstitutions) {
            throw new IllegalStateException("Cannot configure included build after dependency substitutions are resolved.");
        }
        this.dependencySubstitutionActions.add(action);
    }

    @Override
    public List<Action<? super DependencySubstitutions>> getRegisteredDependencySubstitutions() {
        this.resolvedDependencySubstitutions = true;
        return this.dependencySubstitutionActions;
    }

    @Override
    public Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> getAvailableModules() {
        if (this.availableModules == null) {
            GradleInternal gradle = this.getConfiguredBuild();
            this.availableModules = Sets.newLinkedHashSet();
            for (Project project : gradle.getRootProject().getAllprojects()) {
                this.registerProject(this.availableModules, (ProjectInternal)project);
            }
        }
        return this.availableModules;
    }

    private void registerProject(Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> availableModules, ProjectInternal project) {
        LocalComponentRegistry localComponentRegistry = project.getServices().get(LocalComponentRegistry.class);
        DefaultProjectComponentIdentifier projectIdentifier = new DefaultProjectComponentIdentifier(this.buildIdentifier, project.getIdentityPath(), project.getProjectPath(), project.getName());
        DefaultLocalComponentMetadata originalComponent = (DefaultLocalComponentMetadata)localComponentRegistry.getComponent(projectIdentifier);
        ModuleVersionIdentifier moduleId = originalComponent.getModuleVersionId();
        LOGGER.info("Registering " + project + " in composite build. Will substitute for module '" + moduleId.getModule() + "'.");
        availableModules.add(Pair.of(moduleId, projectIdentifier));
    }

    @Override
    public ProjectComponentIdentifier idToReferenceProjectFromAnotherBuild(ProjectComponentIdentifier identifier) {
        DefaultProjectComponentIdentifier original = (DefaultProjectComponentIdentifier)identifier;
        return new DefaultProjectComponentIdentifier(new ForeignBuildIdentifier(this.buildIdentifier.getName(), this.getName()), original.getIdentityPath(), original.projectPath(), original.getProjectName());
    }

    @Override
    public SettingsInternal getLoadedSettings() {
        return this.getGradleLauncher().getLoadedSettings();
    }

    @Override
    public GradleInternal getConfiguredBuild() {
        return this.getGradleLauncher().getConfiguredBuild();
    }

    @Override
    public void finishBuild() {
        if (this.gradleLauncher == null || this.discardLauncher) {
            return;
        }
        this.gradleLauncher.finishBuild();
    }

    @Override
    public synchronized void addTasks(Iterable<String> taskPaths) {
        this.getGradleLauncher().scheduleTasks(taskPaths);
    }

    private GradleLauncher getGradleLauncher() {
        if (this.gradleLauncher == null) {
            this.gradleLauncher = this.gradleLauncherFactory.nestedInstance(this.buildDefinition.newInstance(), this);
        }
        return this.gradleLauncher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void execute(Iterable<String> tasks, Object listener) {
        this.cleanupLauncherIfRequired();
        final GradleLauncher launcher = this.getGradleLauncher();
        launcher.addListener(listener);
        launcher.scheduleTasks(tasks);
        WorkerLeaseService workerLeaseService = launcher.getGradle().getServices().get(WorkerLeaseService.class);
        try {
            workerLeaseService.withSharedLease(this.parentLease, new Runnable(){

                @Override
                public void run() {
                    launcher.executeTasks();
                }
            });
        }
        finally {
            this.markAsNotReusable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupLauncherIfRequired() {
        if (this.gradleLauncher != null && this.discardLauncher) {
            try {
                this.gradleLauncher.stop();
            }
            finally {
                this.gradleLauncher = null;
                this.discardLauncher = false;
            }
        }
    }

    private void markAsNotReusable() {
        this.discardLauncher = true;
    }

    public String toString() {
        return String.format("includedBuild[%s]", this.getProjectDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            if (this.gradleLauncher != null) {
                this.gradleLauncher.stop();
            }
        }
        finally {
            this.gradleLauncher = null;
            this.discardLauncher = false;
        }
    }
}

