/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.composite.internal.IncludedBuildTaskReference;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.model.IvyArtifactName;

class CompositeProjectComponentArtifactMetadata
implements LocalComponentArtifactMetadata,
ComponentArtifactIdentifier,
DisplayName {
    private final ProjectComponentIdentifier componentIdentifier;
    private final IvyArtifactName ivyArtifactName;
    private final File artifactFile;
    private final Set<String> tasks;

    public CompositeProjectComponentArtifactMetadata(ProjectComponentIdentifier componentIdentifier, IvyArtifactName ivyArtifactName, File artifactFile, Set<String> tasks) {
        this.componentIdentifier = componentIdentifier;
        this.ivyArtifactName = ivyArtifactName;
        this.artifactFile = artifactFile;
        this.tasks = tasks;
    }

    @Override
    public ProjectComponentIdentifier getComponentId() {
        return this.componentIdentifier;
    }

    @Override
    public ComponentArtifactIdentifier getId() {
        return this;
    }

    @Override
    public IvyArtifactName getName() {
        return this.ivyArtifactName;
    }

    @Override
    public ProjectComponentIdentifier getComponentIdentifier() {
        return this.componentIdentifier;
    }

    @Override
    public String getDisplayName() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.ivyArtifactName.toString());
        builder.append(" (");
        builder.append(this.componentIdentifier.toString());
        builder.append(")");
        return builder.toString();
    }

    @Override
    public String getCapitalizedDisplayName() {
        return this.getDisplayName();
    }

    @Override
    public File getFile() {
        return this.artifactFile;
    }

    public Set<String> getTasks() {
        return this.tasks;
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return new AbstractTaskDependency(){

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                for (String task : CompositeProjectComponentArtifactMetadata.this.tasks) {
                    context.add(new IncludedBuildTaskReference(CompositeProjectComponentArtifactMetadata.this.componentIdentifier.getBuild(), task));
                }
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompositeProjectComponentArtifactMetadata)) {
            return false;
        }
        CompositeProjectComponentArtifactMetadata that = (CompositeProjectComponentArtifactMetadata)o;
        return this.artifactFile.equals(that.artifactFile);
    }

    public int hashCode() {
        return this.artifactFile.hashCode();
    }
}

