/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import java.util.Collection;
import java.util.Map;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.ImplementationSnapshot;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.caching.internal.tasks.DebuggingTaskOutputCachingBuildCacheKeyBuilder;
import org.gradle.caching.internal.tasks.DefaultTaskOutputCachingBuildCacheKeyBuilder;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKeyBuilder;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;

public class TaskCacheKeyCalculator {
    private final boolean buildCacheDebugLogging;

    public TaskCacheKeyCalculator(boolean buildCacheDebugLogging) {
        this.buildCacheDebugLogging = buildCacheDebugLogging;
    }

    public TaskOutputCachingBuildCacheKey calculate(TaskInternal task, TaskExecution execution) {
        TaskOutputCachingBuildCacheKeyBuilder builder = new DefaultTaskOutputCachingBuildCacheKeyBuilder(task.getIdentityPath());
        if (this.buildCacheDebugLogging) {
            builder = new DebuggingTaskOutputCachingBuildCacheKeyBuilder(builder);
        }
        builder.appendTaskImplementation(execution.getTaskImplementation());
        builder.appendTaskActionImplementations((Collection<ImplementationSnapshot>)execution.getTaskActionImplementations());
        ImmutableSortedMap<String, ValueSnapshot> inputProperties = execution.getInputProperties();
        for (Map.Entry entry : inputProperties.entrySet()) {
            DefaultBuildCacheHasher newHasher = new DefaultBuildCacheHasher();
            ((ValueSnapshot)entry.getValue()).appendToHasher(newHasher);
            if (newHasher.isValid()) {
                HashCode hash = newHasher.hash();
                builder.appendInputPropertyHash((String)entry.getKey(), hash);
                continue;
            }
            builder.inputPropertyLoadedByUnknownClassLoader((String)entry.getKey());
        }
        ImmutableSortedMap<String, FileCollectionSnapshot> inputFilesSnapshots = execution.getInputFilesSnapshot();
        for (Map.Entry entry : inputFilesSnapshots.entrySet()) {
            FileCollectionSnapshot snapshot = (FileCollectionSnapshot)entry.getValue();
            builder.appendInputPropertyHash((String)entry.getKey(), snapshot.getHash());
        }
        ImmutableSortedSet<String> outputPropertyNamesForCacheKey = execution.getOutputPropertyNamesForCacheKey();
        for (String cacheableOutputPropertyName : outputPropertyNamesForCacheKey) {
            builder.appendOutputPropertyName(cacheableOutputPropertyName);
        }
        return builder.build();
    }
}

