/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.locklistener;

import java.net.DatagramPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.cache.internal.locklistener.FileLockCommunicator;
import org.gradle.cache.internal.locklistener.FileLockContentionHandler;
import org.gradle.cache.internal.locklistener.GracefullyStoppedException;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.remote.internal.inet.InetAddressFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileLockContentionHandler
implements FileLockContentionHandler,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFileLockContentionHandler.class);
    private static final int PING_DELAY = 1000;
    private final Lock lock = new ReentrantLock();
    private final Map<Long, ContendedAction> contendedActions = new HashMap<Long, ContendedAction>();
    private final Map<Long, Integer> unlocksRequestedFrom = new HashMap<Long, Integer>();
    private final Map<Long, Integer> unlocksConfirmedFrom = new HashMap<Long, Integer>();
    private final ExecutorFactory executorFactory;
    private final InetAddressFactory addressFactory;
    private FileLockCommunicator communicator;
    private ManagedExecutor fileLockRequestListener;
    private ManagedExecutor unlockActionExecutor;
    private boolean stopped;

    public DefaultFileLockContentionHandler(ExecutorFactory executorFactory, InetAddressFactory addressFactory) {
        this.executorFactory = executorFactory;
        this.addressFactory = addressFactory;
    }

    private Runnable listener() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    LOGGER.debug("Starting file lock listener thread.");
                    this.doRun();
                }
                catch (Throwable t) {
                    LOGGER.error("Problems handling incoming cache access requests.", t);
                }
                finally {
                    LOGGER.debug("File lock listener thread completed.");
                }
            }

            private void doRun() {
                while (true) {
                    long lockId;
                    DatagramPacket packet;
                    try {
                        packet = DefaultFileLockContentionHandler.this.communicator.receive();
                        lockId = DefaultFileLockContentionHandler.this.communicator.decodeLockId(packet);
                    }
                    catch (GracefullyStoppedException e) {
                        return;
                    }
                    DefaultFileLockContentionHandler.this.lock.lock();
                    ContendedAction contendedAction = (ContendedAction)DefaultFileLockContentionHandler.this.contendedActions.get(lockId);
                    if (contendedAction == null) {
                        DefaultFileLockContentionHandler.this.acceptConfirmationAsLockRequester(lockId, packet.getPort());
                    } else {
                        if (!contendedAction.running) {
                            DefaultFileLockContentionHandler.this.startLockReleaseAsLockHolder(contendedAction);
                        }
                        DefaultFileLockContentionHandler.this.communicator.confirmUnlockRequest(packet);
                    }
                    DefaultFileLockContentionHandler.this.lock.unlock();
                }
            }
        };
    }

    private void startLockReleaseAsLockHolder(ContendedAction contendedAction) {
        contendedAction.running = true;
        this.unlockActionExecutor.execute(contendedAction.action);
    }

    private void acceptConfirmationAsLockRequester(long lockId, int port) {
        this.unlocksConfirmedFrom.put(lockId, port);
        LOGGER.debug("Gradle process at port {} confirmed unlock request for lock with id {}.", (Object)port, (Object)lockId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(long lockId, Runnable whenContended) {
        this.lock.lock();
        this.unlocksRequestedFrom.remove(lockId);
        this.unlocksConfirmedFrom.remove(lockId);
        try {
            this.assertNotStopped();
            if (this.communicator == null) {
                throw new IllegalStateException("Must initialize the handler by reserving the port first.");
            }
            if (this.fileLockRequestListener == null) {
                this.fileLockRequestListener = this.executorFactory.create("File lock request listener");
                this.fileLockRequestListener.execute(this.listener());
            }
            if (this.unlockActionExecutor == null) {
                this.unlockActionExecutor = this.executorFactory.create("File lock release action executor");
            }
            if (this.contendedActions.containsKey(lockId)) {
                throw new UnsupportedOperationException("Multiple contention actions for a given lock are currently not supported.");
            }
            this.contendedActions.put(lockId, new ContendedAction(whenContended));
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean maybePingOwner(int port, long lockId, String displayName, long timeElapsed) {
        if (Integer.valueOf(port).equals(this.unlocksConfirmedFrom.get(lockId))) {
            return false;
        }
        if (Integer.valueOf(port).equals(this.unlocksRequestedFrom.get(lockId)) && timeElapsed < 1000L) {
            return false;
        }
        boolean pingSentSuccessfully = this.getCommunicator().pingOwner(port, lockId, displayName);
        if (pingSentSuccessfully) {
            this.lock.lock();
            this.unlocksRequestedFrom.put(lockId, port);
            this.lock.unlock();
        }
        return pingSentSuccessfully;
    }

    private void assertNotStopped() {
        if (this.stopped) {
            throw new IllegalStateException("Cannot start managing file contention because this handler has been closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(long lockId) {
        this.lock.lock();
        try {
            this.contendedActions.remove(lockId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.lock.lock();
        try {
            this.stopped = true;
            this.contendedActions.clear();
            if (this.communicator != null) {
                this.communicator.stop();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.fileLockRequestListener != null) {
            this.fileLockRequestListener.stop();
        }
        if (this.unlockActionExecutor != null) {
            this.unlockActionExecutor.stop();
        }
    }

    @Override
    public int reservePort() {
        return this.getCommunicator().getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLockCommunicator getCommunicator() {
        this.lock.lock();
        try {
            this.assertNotStopped();
            if (this.communicator == null) {
                this.communicator = new FileLockCommunicator(this.addressFactory);
            }
            FileLockCommunicator fileLockCommunicator = this.communicator;
            return fileLockCommunicator;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class ContendedAction {
        private final Runnable action;
        private boolean running;

        private ContendedAction(Runnable action) {
            this.action = action;
        }
    }
}

