/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.impldep.com.google.common.util.concurrent.Striped;

public abstract class ProducerGuard<T> {
    public static <T> ProducerGuard<T> adaptive() {
        return new AdaptiveProducerGuard();
    }

    public static <T> ProducerGuard<T> striped() {
        return new StripedProducerGuard();
    }

    public static <T> ProducerGuard<T> serial() {
        return new SerialProducerGuard();
    }

    private ProducerGuard() {
    }

    public abstract <V> V guardByKey(T var1, Factory<V> var2);

    private static class SerialProducerGuard<T>
    extends ProducerGuard<T> {
        private final Lock lock = new ReentrantLock();

        private SerialProducerGuard() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <V> V guardByKey(T key, Factory<V> factory) {
            try {
                this.lock.lock();
                V v = factory.create();
                return v;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static class StripedProducerGuard<T>
    extends ProducerGuard<T> {
        private final Striped<Lock> locks = Striped.lock((int)(Runtime.getRuntime().availableProcessors() * 4));

        private StripedProducerGuard() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <V> V guardByKey(T key, Factory<V> factory) {
            Lock lock = (Lock)this.locks.get(key);
            try {
                lock.lock();
                V v = factory.create();
                return v;
            }
            finally {
                lock.unlock();
            }
        }
    }

    private static class AdaptiveProducerGuard<T>
    extends ProducerGuard<T> {
        private final Set<T> producing = Sets.newHashSet();

        private AdaptiveProducerGuard() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <V> V guardByKey(T key, Factory<V> factory) {
            Set<Object> set = this.producing;
            synchronized (set) {
                while (!this.producing.add(key)) {
                    try {
                        this.producing.wait();
                    }
                    catch (InterruptedException e) {
                        throw UncheckedException.throwAsUncheckedException(e);
                    }
                }
            }
            try {
                set = factory.create();
                return (V)set;
            }
            finally {
                Set<T> set2 = this.producing;
                synchronized (set2) {
                    this.producing.remove(key);
                    this.producing.notifyAll();
                }
            }
        }
    }
}

