/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.AbstractCacheCleanup;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedAgeOldestCacheCleanup
extends AbstractCacheCleanup {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedAgeOldestCacheCleanup.class);
    private final long minimumTimestamp;

    public FixedAgeOldestCacheCleanup(long ageInDays) {
        this.minimumTimestamp = Math.max(0L, System.currentTimeMillis() - TimeUnit.DAYS.toMillis(ageInDays));
    }

    @Override
    protected List<File> findFilesToDelete(PersistentCache persistentCache, File[] filesEligibleForCleanup) {
        LOGGER.info("{} remove files older than {}.", (Object)persistentCache, (Object)new Date(this.minimumTimestamp));
        ArrayList filesForDeletion = Lists.newArrayListWithCapacity((int)filesEligibleForCleanup.length);
        for (File file : filesEligibleForCleanup) {
            if (file.lastModified() >= this.minimumTimestamp) continue;
            filesForDeletion.add(file);
        }
        return filesForDeletion;
    }
}

