/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheValidator;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CacheCleanupAction;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.cache.internal.DefaultPersistentDirectoryStore;
import org.gradle.cache.internal.ReferencablePersistentCache;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.util.GFileUtils;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPersistentDirectoryCache
extends DefaultPersistentDirectoryStore
implements ReferencablePersistentCache {
    public static final int CLEANUP_INTERVAL_IN_HOURS = 24;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPersistentDirectoryCache.class);
    private final Properties properties = new Properties();
    private final Action<? super PersistentCache> initAction;
    private final CleanupAction cleanupAction;
    private final CacheValidator validator;
    private boolean didRebuild;

    public DefaultPersistentDirectoryCache(File dir, String displayName, CacheValidator validator, Map<String, ?> properties, CacheBuilder.LockTarget lockTarget, LockOptions lockOptions, Action<? super PersistentCache> initAction, CleanupAction cleanupAction, FileLockManager lockManager, ExecutorFactory executorFactory) {
        super(dir, displayName, lockTarget, lockOptions, lockManager, executorFactory);
        this.validator = validator;
        this.initAction = initAction;
        this.cleanupAction = cleanupAction;
        this.properties.putAll(properties);
    }

    @Override
    protected CacheInitializationAction getInitAction() {
        return new Initializer();
    }

    @Override
    public CacheCleanupAction getCleanupAction() {
        return new Cleanup();
    }

    public Properties getProperties() {
        return this.properties;
    }

    private class Cleanup
    implements CacheCleanupAction {
        private Cleanup() {
        }

        @Override
        public boolean requiresCleanup() {
            if (DefaultPersistentDirectoryCache.this.cleanupAction != null) {
                if (!DefaultPersistentDirectoryCache.this.gcFile.exists()) {
                    GFileUtils.touch(DefaultPersistentDirectoryCache.this.gcFile);
                } else {
                    long duration = System.currentTimeMillis() - DefaultPersistentDirectoryCache.this.gcFile.lastModified();
                    long timeInHours = TimeUnit.MILLISECONDS.toHours(duration);
                    LOGGER.debug("{} has last been cleaned up {} hours ago", (Object)DefaultPersistentDirectoryCache.this, (Object)timeInHours);
                    return timeInHours >= 24L;
                }
            }
            return false;
        }

        @Override
        public void cleanup() {
            if (DefaultPersistentDirectoryCache.this.cleanupAction != null) {
                Timer timer = Time.startTimer();
                DefaultPersistentDirectoryCache.this.cleanupAction.clean(DefaultPersistentDirectoryCache.this);
                LOGGER.info("{} cleaned up in {}.", (Object)DefaultPersistentDirectoryCache.this, (Object)timer.getElapsed());
            }
            GFileUtils.touch(DefaultPersistentDirectoryCache.this.gcFile);
        }
    }

    private class Initializer
    implements CacheInitializationAction {
        private Initializer() {
        }

        @Override
        public boolean requiresInitialization(FileLock lock) {
            if (!DefaultPersistentDirectoryCache.this.didRebuild && DefaultPersistentDirectoryCache.this.validator != null && !DefaultPersistentDirectoryCache.this.validator.isValid()) {
                LOGGER.debug("Invalidating {} as cache validator return false.", (Object)DefaultPersistentDirectoryCache.this);
                return true;
            }
            if (!lock.getUnlockedCleanly()) {
                if (lock.getState().canDetectChanges() && !lock.getState().isInInitialState()) {
                    LOGGER.warn("Invalidating {} as it was not closed cleanly.", (Object)DefaultPersistentDirectoryCache.this);
                }
                return true;
            }
            Properties cachedProperties = GUtil.loadProperties(DefaultPersistentDirectoryCache.this.propertiesFile);
            for (Map.Entry<Object, Object> entry : DefaultPersistentDirectoryCache.this.properties.entrySet()) {
                String currentValue;
                String previousValue = cachedProperties.getProperty(entry.getKey().toString());
                if (previousValue.equals(currentValue = entry.getValue().toString())) continue;
                LOGGER.debug("Invalidating {} as cache property {} has changed from {} to {}.", new Object[]{DefaultPersistentDirectoryCache.this, entry.getKey(), previousValue, currentValue});
                return true;
            }
            return false;
        }

        @Override
        public void initialize(FileLock fileLock) {
            File[] files = DefaultPersistentDirectoryCache.this.getBaseDir().listFiles();
            if (files == null) {
                throw new UncheckedIOException("Cannot list files in " + DefaultPersistentDirectoryCache.this.getBaseDir());
            }
            for (File file : files) {
                if (fileLock.isLockFile(file) || file.equals(DefaultPersistentDirectoryCache.this.propertiesFile)) continue;
                GFileUtils.forceDelete(file);
            }
            if (DefaultPersistentDirectoryCache.this.initAction != null) {
                DefaultPersistentDirectoryCache.this.initAction.execute(DefaultPersistentDirectoryCache.this);
            }
            GUtil.saveProperties(DefaultPersistentDirectoryCache.this.properties, DefaultPersistentDirectoryCache.this.propertiesFile);
            DefaultPersistentDirectoryCache.this.didRebuild = true;
        }
    }
}

