/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.tasks.internal;

import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.wrapper.Wrapper;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.tasks.InitBuild;

public class TaskConfiguration {
    public static final String INIT_BUILD_TASK_NAME = "init";
    public static final String GROUP = "Build Setup";

    public static void configureInit(InitBuild init) {
        init.setGroup(GROUP);
        init.setDescription("Initializes a new Gradle build.");
        final Project project = init.getProject();
        init.onlyIf((Spec<? super Task>)new Spec<Task>(){

            @Override
            public boolean isSatisfiedBy(Task element) {
                String skippedMsg = TaskConfiguration.reasonToSkip(project);
                if (skippedMsg != null) {
                    project.getLogger().warn(skippedMsg);
                    return false;
                }
                return true;
            }
        });
        init.dependsOn(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (TaskConfiguration.reasonToSkip(project) == null) {
                    return "wrapper";
                }
                return null;
            }
        });
    }

    private static String reasonToSkip(Project project) {
        for (BuildInitDsl dsl : BuildInitDsl.values()) {
            String buildFileName = dsl.fileNameFor("build");
            if (project.file(buildFileName).exists()) {
                return "The build file '" + buildFileName + "' already exists. Skipping build initialization.";
            }
            String settingsFileName = dsl.fileNameFor("settings");
            if (!project.file(settingsFileName).exists()) continue;
            return "The settings file '" + settingsFileName + "' already exists. Skipping build initialization.";
        }
        File buildFile = project.getBuildFile();
        if (buildFile != null && buildFile.exists()) {
            return "The build file '" + buildFile.getName() + "' already exists. Skipping build initialization.";
        }
        if (project.getSubprojects().size() > 0) {
            return "This Gradle project appears to be part of an existing multi-project Gradle build. Skipping build initialization.";
        }
        return null;
    }

    public static void configureWrapper(Wrapper wrapper) {
        wrapper.setGroup(GROUP);
        wrapper.setDescription("Generates Gradle wrapper files.");
    }

    public static void addInitPlaceholder(ProjectInternal projectInternal) {
        if (projectInternal.getParent() == null) {
            projectInternal.getTasks().addPlaceholderAction(INIT_BUILD_TASK_NAME, InitBuild.class, new InitBuildAction());
        }
    }

    public static void addWrapperPlaceholder(ProjectInternal projectInternal) {
        if (projectInternal.getParent() == null) {
            projectInternal.getTasks().addPlaceholderAction("wrapper", Wrapper.class, new WrapperAction());
        }
    }

    private static class WrapperAction
    implements Action<Wrapper> {
        private WrapperAction() {
        }

        @Override
        public void execute(Wrapper wrapper) {
            TaskConfiguration.configureWrapper(wrapper);
        }
    }

    private static class InitBuildAction
    implements Action<InitBuild> {
        private InitBuildAction() {
        }

        @Override
        public void execute(InitBuild initBuild) {
            TaskConfiguration.configureInit(initBuild);
        }
    }
}

