/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.text;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.logging.text.LinePrefixingStyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.reporting.ReportRenderer;

public class DefaultTextReportBuilder
implements TextReportBuilder {
    public static final String SEPARATOR = "------------------------------------------------------------";
    public static final String INDENT = "    ";
    private int depth;
    private boolean hasTitledItems;
    private StyledTextOutput textOutput;
    private final FileResolver fileResolver;

    public DefaultTextReportBuilder(StyledTextOutput textOutput, FileResolver fileResolver) {
        this.textOutput = textOutput;
        this.fileResolver = fileResolver;
    }

    @Override
    public void item(String title, String value) {
        this.hasTitledItems = true;
        LinePrefixingStyledTextOutput itemOutput = new LinePrefixingStyledTextOutput(this.textOutput, INDENT, false);
        itemOutput.append(title).append(": ");
        itemOutput.append(value).println();
    }

    @Override
    public void item(String title, File value) {
        this.item(title, this.fileResolver.resolveAsRelativePath(value));
    }

    @Override
    public void item(String value) {
        this.hasTitledItems = true;
        this.textOutput.append(value).println();
    }

    @Override
    public void item(String title, Iterable<String> values) {
        this.item(title, Joiner.on((String)", ").join(values));
    }

    @Override
    public void item(File value) {
        this.item(this.fileResolver.resolveAsRelativePath(value));
    }

    @Override
    public <T> void item(final T value, final ReportRenderer<T, TextReportBuilder> renderer) {
        this.renderItem(new Action<TextReportBuilder>(){

            @Override
            public void execute(TextReportBuilder textReportBuilder) {
                try {
                    renderer.render(value, textReportBuilder);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
    }

    @Override
    public void heading(String heading) {
        if (this.depth == 0) {
            this.textOutput.println().style(StyledTextOutput.Style.Header);
            this.textOutput.println(SEPARATOR);
            this.textOutput.println(heading);
            this.textOutput.text(SEPARATOR);
            this.textOutput.style(StyledTextOutput.Style.Normal);
            this.textOutput.println().println();
        } else if (this.depth == 1) {
            this.writeSubheading(heading);
        } else {
            this.textOutput.println(heading);
            this.textOutput = new LinePrefixingStyledTextOutput(this.textOutput, INDENT);
        }
        ++this.depth;
    }

    @Override
    public void subheading(String heading) {
        this.writeSubheading(heading);
        if (this.depth == 0) {
            this.depth = 1;
        }
    }

    private void writeSubheading(String heading) {
        this.textOutput.style(StyledTextOutput.Style.Header).println(heading);
        for (int i = 0; i < heading.length(); ++i) {
            this.textOutput.text("-");
        }
        this.textOutput.style(StyledTextOutput.Style.Normal).println();
    }

    @Override
    public <T> void collection(String title, Collection<? extends T> items, ReportRenderer<T, TextReportBuilder> renderer, String elementsPlural) {
        if (this.depth <= 1 && !this.hasTitledItems) {
            this.writeSubheading(title);
        } else if (this.depth == 2 && !this.hasTitledItems) {
            this.textOutput.println(title);
        } else {
            this.textOutput.append(title).println(":");
        }
        if (items.isEmpty()) {
            this.textOutput.formatln("    No %s.", elementsPlural);
            return;
        }
        this.collection(items, renderer);
    }

    @Override
    public <T> void collection(Iterable<? extends T> items, final ReportRenderer<T, TextReportBuilder> renderer) {
        for (final T t : items) {
            this.nested(new Action<TextReportBuilder>(){

                @Override
                public void execute(TextReportBuilder textReportBuilder) {
                    try {
                        renderer.render(t, textReportBuilder);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            });
        }
    }

    @Override
    public StyledTextOutput getOutput() {
        return this.textOutput;
    }

    private void nested(final Action<TextReportBuilder> action) {
        final boolean indent = this.depth > 1 || this.hasTitledItems;
        this.renderItem(new Action<TextReportBuilder>(){

            @Override
            public void execute(TextReportBuilder textReportBuilder) {
                if (indent) {
                    DefaultTextReportBuilder.this.textOutput = new LinePrefixingStyledTextOutput(DefaultTextReportBuilder.this.textOutput, DefaultTextReportBuilder.INDENT);
                }
                DefaultTextReportBuilder.this.depth++;
                action.execute(textReportBuilder);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderItem(Action<TextReportBuilder> action) {
        StyledTextOutput original = this.textOutput;
        int originalDepth = this.depth;
        boolean originalItems = this.hasTitledItems;
        try {
            this.hasTitledItems = false;
            action.execute(this);
        }
        finally {
            this.textOutput = original;
            this.depth = originalDepth;
            this.hasTitledItems = originalItems;
        }
    }
}

