/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.dsl;

import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.specs.Spec;

class DependencyResultSpec
implements Spec<DependencyResult> {
    private final String stringNotation;

    public DependencyResultSpec(String stringNotation) {
        this.stringNotation = stringNotation;
    }

    @Override
    public boolean isSatisfiedBy(DependencyResult candidate) {
        if (candidate instanceof ResolvedDependencyResult) {
            return this.matchesRequested(candidate) || this.matchesSelected((ResolvedDependencyResult)candidate);
        }
        return this.matchesRequested(candidate);
    }

    private boolean matchesRequested(DependencyResult candidate) {
        ComponentSelector requested = candidate.getRequested();
        if (requested instanceof ModuleComponentSelector) {
            ModuleComponentSelector requestedModule = (ModuleComponentSelector)requested;
            String requestedCandidate = requestedModule.getGroup() + ":" + requestedModule.getModule() + ":" + requestedModule.getVersionConstraint().getPreferredVersion();
            return requestedCandidate.contains(this.stringNotation);
        }
        return false;
    }

    private boolean matchesSelected(ResolvedDependencyResult candidate) {
        ModuleVersionIdentifier selected = candidate.getSelected().getModuleVersion();
        String selectedCandidate = selected.getGroup() + ":" + selected.getModule() + ":" + selected.getVersion();
        return selectedCandidate.contains(this.stringNotation);
    }
}

