/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.changedetection.changes.IncrementalTaskInputsInternal;
import org.gradle.api.internal.tasks.JavaToolChainFactory;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.CompilerForkUtils;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompileSpecFactory;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilerFactory;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorPathFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.jvm.internal.toolchain.JavaToolChainInternal;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.platform.internal.DefaultJavaPlatform;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.CompilerUtil;

@CacheableTask
public class JavaCompile
extends AbstractCompile {
    private final CompileOptions compileOptions;
    private JavaToolChain toolChain;

    public JavaCompile() {
        CompileOptions compileOptions;
        this.compileOptions = compileOptions = this.getServices().get(ObjectFactory.class).newInstance(CompileOptions.class, new Object[0]);
        CompilerForkUtils.doNotCacheIfForkingViaExecutable(compileOptions, this.getOutputs());
        this.include("**/*.java");
    }

    @Override
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public FileTree getSource() {
        return super.getSource();
    }

    @Nested
    @Incubating
    public JavaToolChain getToolChain() {
        if (this.toolChain != null) {
            return this.toolChain;
        }
        return this.getJavaToolChainFactory().forCompileOptions(this.getOptions());
    }

    @Incubating
    public void setToolChain(JavaToolChain toolChain) {
        this.toolChain = toolChain;
    }

    @TaskAction
    protected void compile(IncrementalTaskInputs inputs) {
        if (!this.compileOptions.isIncremental()) {
            this.compile();
            return;
        }
        DefaultJavaCompileSpec spec = this.createSpec();
        Compiler<JavaCompileSpec> incrementalCompiler = this.getIncrementalCompilerFactory().makeIncremental(this.createCompiler(spec), this.getPath(), (IncrementalTaskInputsInternal)inputs, this.getSource());
        this.performCompilation(spec, incrementalCompiler);
    }

    @Inject
    protected IncrementalCompilerFactory getIncrementalCompilerFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected JavaToolChainFactory getJavaToolChainFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void compile() {
        DefaultJavaCompileSpec spec = this.createSpec();
        spec.setSourceFiles(this.getSource());
        this.performCompilation(spec, this.createCompiler(spec));
    }

    private CleaningJavaCompiler createCompiler(JavaCompileSpec spec) {
        Compiler<JavaCompileSpec> javaCompiler = CompilerUtil.castCompiler(((JavaToolChainInternal)this.getToolChain()).select(this.getPlatform()).newCompiler(spec.getClass()));
        return new CleaningJavaCompiler(javaCompiler, this.getOutputs());
    }

    @Nested
    protected JavaPlatform getPlatform() {
        return new DefaultJavaPlatform(JavaVersion.toVersion(this.getTargetCompatibility()));
    }

    private void performCompilation(JavaCompileSpec spec, Compiler<JavaCompileSpec> compiler) {
        WorkResult result = compiler.execute(spec);
        this.setDidWork(result.getDidWork());
    }

    private DefaultJavaCompileSpec createSpec() {
        DefaultJavaCompileSpec spec = (DefaultJavaCompileSpec)new DefaultJavaCompileSpecFactory(this.compileOptions).create();
        spec.setDestinationDir(this.getDestinationDir());
        spec.setWorkingDir(this.getProject().getProjectDir());
        spec.setTempDir(this.getTemporaryDir());
        spec.setCompileClasspath((List<File>)ImmutableList.copyOf((Iterable)this.getClasspath()));
        spec.setAnnotationProcessorPath((List<File>)ImmutableList.copyOf((Iterable)this.getEffectiveAnnotationProcessorPath()));
        spec.setTargetCompatibility(this.getTargetCompatibility());
        spec.setSourceCompatibility(this.getSourceCompatibility());
        spec.setCompileOptions(this.compileOptions);
        return spec;
    }

    @Nested
    public CompileOptions getOptions() {
        return this.compileOptions;
    }

    @Override
    @CompileClasspath
    public FileCollection getClasspath() {
        return super.getClasspath();
    }

    @Incubating
    @Classpath
    public FileCollection getEffectiveAnnotationProcessorPath() {
        AnnotationProcessorPathFactory annotationProcessorPathFactory = this.getServices().get(AnnotationProcessorPathFactory.class);
        return annotationProcessorPathFactory.getEffectiveAnnotationProcessorClasspath(this.compileOptions, this.getClasspath());
    }
}

