/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.plugins;

import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.NamedDomainObjectList;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.ivy.internal.artifact.IvyArtifactNotationParserFactory;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyPublication;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyPublicationIdentity;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.api.publish.ivy.tasks.GenerateIvyDescriptor;
import org.gradle.api.publish.ivy.tasks.PublishToIvyRepository;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.api.publish.tasks.GenerateModuleMetadata;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.model.Path;

public class IvyPublishPlugin
implements Plugin<Project> {
    private final Instantiator instantiator;
    private final ObjectFactory objectFactory;
    private final DependencyMetaDataProvider dependencyMetaDataProvider;
    private final FileResolver fileResolver;
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private final FileCollectionFactory fileCollectionFactory;
    private final ImmutableAttributesFactory immutableAttributesFactory;
    private final FeaturePreviews featurePreviews;

    @Inject
    public IvyPublishPlugin(Instantiator instantiator, ObjectFactory objectFactory, DependencyMetaDataProvider dependencyMetaDataProvider, FileResolver fileResolver, ProjectDependencyPublicationResolver projectDependencyResolver, FileCollectionFactory fileCollectionFactory, ImmutableAttributesFactory immutableAttributesFactory, FeaturePreviews featurePreviews) {
        this.instantiator = instantiator;
        this.objectFactory = objectFactory;
        this.dependencyMetaDataProvider = dependencyMetaDataProvider;
        this.fileResolver = fileResolver;
        this.projectDependencyResolver = projectDependencyResolver;
        this.fileCollectionFactory = fileCollectionFactory;
        this.immutableAttributesFactory = immutableAttributesFactory;
        this.featurePreviews = featurePreviews;
    }

    @Override
    public void apply(final Project project) {
        project.getPluginManager().apply(PublishingPlugin.class);
        project.getExtensions().configure(PublishingExtension.class, new Action<PublishingExtension>(){

            @Override
            public void execute(PublishingExtension extension) {
                extension.getPublications().registerFactory(IvyPublication.class, new IvyPublicationFactory(IvyPublishPlugin.this.dependencyMetaDataProvider, IvyPublishPlugin.this.instantiator, IvyPublishPlugin.this.objectFactory, IvyPublishPlugin.this.fileResolver));
                IvyPublishPlugin.this.createTasksLater(project, extension, project.getLayout().getBuildDirectory());
            }
        });
    }

    private void createTasksLater(final Project project, final PublishingExtension publishingExtension, final DirectoryProperty buildDir) {
        final TaskContainer tasks = project.getTasks();
        final NamedDomainObjectSet<IvyPublicationInternal> publications = publishingExtension.getPublications().withType(IvyPublicationInternal.class);
        publications.all(new Action<IvyPublicationInternal>(){

            @Override
            public void execute(IvyPublicationInternal publication) {
                String publicationName = publication.getName();
                IvyPublishPlugin.this.createGenerateIvyDescriptorTask(tasks, publicationName, publication, buildDir);
                IvyPublishPlugin.this.createGenerateMetadataTask(project, tasks, publication, publications, buildDir);
                IvyPublishPlugin.this.createPublishTaskForEachRepository(tasks, publishingExtension, publication, publicationName);
            }
        });
    }

    private void createPublishTaskForEachRepository(final TaskContainer tasks, PublishingExtension publishingExtension, final IvyPublicationInternal publication, final String publicationName) {
        NamedDomainObjectList<IvyArtifactRepository> repositories = publishingExtension.getRepositories().withType(IvyArtifactRepository.class);
        repositories.all(new Action<IvyArtifactRepository>(){

            @Override
            public void execute(IvyArtifactRepository repository) {
                String repositoryName = repository.getName();
                String publishTaskName = "publish" + StringUtils.capitalize((String)publicationName) + "PublicationTo" + StringUtils.capitalize((String)repositoryName) + "Repository";
                IvyPublishPlugin.this.createPublishToRepositoryTask(tasks, publication, publicationName, repository, repositoryName, publishTaskName);
            }
        });
    }

    private void createPublishToRepositoryTask(TaskContainer tasks, final IvyPublicationInternal publication, final String publicationName, final IvyArtifactRepository repository, final String repositoryName, String publishTaskName) {
        tasks.create(publishTaskName, PublishToIvyRepository.class, new Action<PublishToIvyRepository>(){

            @Override
            public void execute(PublishToIvyRepository publishTask) {
                publishTask.setPublication(publication);
                publishTask.setRepository(repository);
                publishTask.setGroup("publishing");
                publishTask.setDescription("Publishes Ivy publication '" + publicationName + "' to Ivy repository '" + repositoryName + "'.");
            }
        });
        tasks.getByName("publish").dependsOn(publishTaskName);
    }

    private void createGenerateIvyDescriptorTask(TaskContainer tasks, final String publicationName, final IvyPublicationInternal publication, final @Path(value="buildDir") DirectoryProperty buildDir) {
        String descriptorTaskName = "generateDescriptorFileFor" + StringUtils.capitalize((String)publicationName) + "Publication";
        GenerateIvyDescriptor generatorTask = tasks.create(descriptorTaskName, GenerateIvyDescriptor.class, new Action<GenerateIvyDescriptor>(){

            @Override
            public void execute(GenerateIvyDescriptor descriptorTask) {
                descriptorTask.setDescription("Generates the Ivy Module Descriptor XML file for publication '" + publicationName + "'.");
                descriptorTask.setGroup("publishing");
                descriptorTask.setDescriptor(publication.getDescriptor());
                descriptorTask.setDestination(buildDir.file("publications/" + publicationName + "/ivy.xml"));
            }
        });
        publication.setIvyDescriptorGenerator(generatorTask);
    }

    private void createGenerateMetadataTask(Project project, TaskContainer tasks, final IvyPublicationInternal publication, final Set<IvyPublicationInternal> publications, final DirectoryProperty buildDir) {
        final String publicationName = publication.getName();
        String descriptorTaskName = "generateMetadataFileFor" + StringUtils.capitalize((String)publicationName) + "Publication";
        GenerateModuleMetadata generatorTask = tasks.create(descriptorTaskName, GenerateModuleMetadata.class, new Action<GenerateModuleMetadata>(){

            @Override
            public void execute(GenerateModuleMetadata generateTask) {
                generateTask.setDescription("Generates the Gradle metadata file for publication '" + publicationName + "'.");
                generateTask.setGroup("publishing");
                generateTask.getPublication().set(publication);
                generateTask.getPublications().set(publications);
                generateTask.getOutputFile().set(buildDir.file("publications/" + publicationName + "/module.json"));
            }
        });
        publication.setModuleDescriptorGenerator(generatorTask);
    }

    private class IvyPublicationFactory
    implements NamedDomainObjectFactory<IvyPublication> {
        private final Instantiator instantiator;
        private final DependencyMetaDataProvider dependencyMetaDataProvider;
        private final ObjectFactory objectFactory;
        private final FileResolver fileResolver;

        private IvyPublicationFactory(DependencyMetaDataProvider dependencyMetaDataProvider, Instantiator instantiator, ObjectFactory objectFactory, FileResolver fileResolver) {
            this.dependencyMetaDataProvider = dependencyMetaDataProvider;
            this.instantiator = instantiator;
            this.objectFactory = objectFactory;
            this.fileResolver = fileResolver;
        }

        @Override
        public IvyPublication create(String name) {
            Module module = this.dependencyMetaDataProvider.getModule();
            DefaultIvyPublicationIdentity publicationIdentity = new DefaultIvyPublicationIdentity(module);
            Object notationParser = new IvyArtifactNotationParserFactory(this.instantiator, this.fileResolver, publicationIdentity).create();
            return this.instantiator.newInstance(DefaultIvyPublication.class, name, this.instantiator, this.objectFactory, publicationIdentity, notationParser, IvyPublishPlugin.this.projectDependencyResolver, IvyPublishPlugin.this.fileCollectionFactory, IvyPublishPlugin.this.immutableAttributesFactory, IvyPublishPlugin.this.featurePreviews);
        }
    }
}

