/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.artifact;

import java.io.File;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.internal.artifact.ArchiveTaskBasedIvyArtifact;
import org.gradle.api.publish.ivy.internal.artifact.FileBasedIvyArtifact;
import org.gradle.api.publish.ivy.internal.artifact.PublishArtifactBasedIvyArtifact;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.internal.Factory;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationConverter;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.internal.typeconversion.TypedNotationConverter;

public class IvyArtifactNotationParserFactory
implements Factory<NotationParser<Object, IvyArtifact>> {
    private final Instantiator instantiator;
    private final FileResolver fileResolver;
    private final IvyPublicationIdentity publicationIdentity;

    public IvyArtifactNotationParserFactory(Instantiator instantiator, FileResolver fileResolver, IvyPublicationIdentity publicationIdentity) {
        this.instantiator = instantiator;
        this.fileResolver = fileResolver;
        this.publicationIdentity = publicationIdentity;
    }

    @Override
    public NotationParser<Object, IvyArtifact> create() {
        FileNotationConverter fileNotationConverter = new FileNotationConverter(this.fileResolver);
        ArchiveTaskNotationConverter archiveTaskNotationConverter = new ArchiveTaskNotationConverter();
        PublishArtifactNotationConverter publishArtifactNotationConverter = new PublishArtifactNotationConverter();
        NotationParser<Object, IvyArtifact> sourceNotationParser = NotationParserBuilder.toType(IvyArtifact.class).converter(archiveTaskNotationConverter).converter(publishArtifactNotationConverter).converter(fileNotationConverter).toComposite();
        IvyArtifactMapNotationConverter ivyArtifactMapNotationConverter = new IvyArtifactMapNotationConverter(sourceNotationParser);
        NotationParserBuilder<IvyArtifact> parserBuilder = NotationParserBuilder.toType(IvyArtifact.class).converter(archiveTaskNotationConverter).converter(publishArtifactNotationConverter).converter(ivyArtifactMapNotationConverter).converter(fileNotationConverter);
        return parserBuilder.toComposite();
    }

    private class IvyArtifactMapNotationConverter
    extends MapNotationConverter<IvyArtifact> {
        private final NotationParser<Object, IvyArtifact> sourceNotationParser;

        private IvyArtifactMapNotationConverter(NotationParser<Object, IvyArtifact> sourceNotationParser) {
            this.sourceNotationParser = sourceNotationParser;
        }

        protected IvyArtifact parseMap(@MapKey(value="source") Object source) {
            return this.sourceNotationParser.parseNotation(source);
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Maps containing a 'source' entry").example("[source: '/path/to/file', extension: 'zip']");
        }
    }

    private class FileNotationConverter
    implements NotationConverter<Object, IvyArtifact> {
        private final NotationParser<Object, File> fileResolverNotationParser;

        private FileNotationConverter(FileResolver fileResolver) {
            this.fileResolverNotationParser = fileResolver.asNotationParser();
        }

        @Override
        public void convert(Object notation, NotationConvertResult<? super IvyArtifact> result) throws TypeConversionException {
            File file = this.fileResolverNotationParser.parseNotation(notation);
            IvyArtifact ivyArtifact = IvyArtifactNotationParserFactory.this.instantiator.newInstance(FileBasedIvyArtifact.class, file, IvyArtifactNotationParserFactory.this.publicationIdentity);
            if (notation instanceof TaskDependencyContainer) {
                ivyArtifact.builtBy(notation);
            }
            result.converted(ivyArtifact);
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
            this.fileResolverNotationParser.describe(visitor);
        }
    }

    private class PublishArtifactNotationConverter
    extends TypedNotationConverter<PublishArtifact, IvyArtifact> {
        private PublishArtifactNotationConverter() {
            super(PublishArtifact.class);
        }

        @Override
        protected IvyArtifact parseType(PublishArtifact publishArtifact) {
            return IvyArtifactNotationParserFactory.this.instantiator.newInstance(PublishArtifactBasedIvyArtifact.class, publishArtifact, IvyArtifactNotationParserFactory.this.publicationIdentity);
        }
    }

    private class ArchiveTaskNotationConverter
    extends TypedNotationConverter<AbstractArchiveTask, IvyArtifact> {
        private ArchiveTaskNotationConverter() {
            super(AbstractArchiveTask.class);
        }

        @Override
        protected IvyArtifact parseType(AbstractArchiveTask archiveTask) {
            return IvyArtifactNotationParserFactory.this.instantiator.newInstance(ArchiveTaskBasedIvyArtifact.class, archiveTask, IvyArtifactNotationParserFactory.this.publicationIdentity);
        }
    }
}

