/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr.internal;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.plugins.antlr.internal.AntlrResult;
import org.gradle.api.plugins.antlr.internal.AntlrSpec;
import org.gradle.api.plugins.antlr.internal.AntlrWorker;
import org.gradle.api.plugins.antlr.internal.antlr2.GenerationPlan;
import org.gradle.api.plugins.antlr.internal.antlr2.GenerationPlanBuilder;
import org.gradle.api.plugins.antlr.internal.antlr2.MetadataExtracter;
import org.gradle.api.plugins.antlr.internal.antlr2.XRef;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.util.RelativePathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntlrExecuter
implements AntlrWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(AntlrExecuter.class);

    @Override
    public AntlrResult runAntlr(AntlrSpec spec) {
        AntlrTool antlrTool = new Antlr4Tool();
        if (antlrTool.available()) {
            LOGGER.info("Processing with ANTLR 4");
            return antlrTool.process(spec);
        }
        antlrTool = new Antlr3Tool();
        if (antlrTool.available()) {
            LOGGER.info("Processing with ANTLR 3");
            return antlrTool.process(spec);
        }
        antlrTool = new Antlr2Tool();
        if (antlrTool.available()) {
            LOGGER.info("Processing with ANTLR 2");
            return antlrTool.process(spec);
        }
        throw new IllegalStateException("No Antlr implementation available");
    }

    private static class Antlr2Tool
    extends AntlrTool {
        private Antlr2Tool() {
        }

        @Override
        public AntlrResult doProcess(AntlrSpec spec) throws ClassNotFoundException {
            XRef xref = new MetadataExtracter().extractMetadata(spec.getGrammarFiles());
            List<GenerationPlan> generationPlans = new GenerationPlanBuilder(spec.getOutputDirectory()).buildGenerationPlans(xref);
            for (GenerationPlan generationPlan : generationPlans) {
                ArrayList generationPlanArguments = Lists.newArrayList(spec.getArguments());
                generationPlanArguments.add("-o");
                generationPlanArguments.add(generationPlan.getGenerationDirectory().getAbsolutePath());
                generationPlanArguments.add(generationPlan.getSource().getAbsolutePath());
                try {
                    this.invoke(generationPlanArguments, null);
                }
                catch (RuntimeException e) {
                    if (e.getMessage().equals("ANTLR Panic: Exiting due to errors.")) {
                        return new AntlrResult(-1, e);
                    }
                    throw e;
                }
            }
            return new AntlrResult(0);
        }

        @Override
        int invoke(List<String> arguments, File inputDirectory) throws ClassNotFoundException {
            Object backedAntlrTool = Antlr2Tool.loadTool("antlr.Tool", null);
            JavaReflectionUtil.method(backedAntlrTool, Integer.class, "doEverything", String[].class).invoke(backedAntlrTool, new Object[]{Antlr2Tool.toArray(arguments)});
            return 0;
        }

        @Override
        public boolean available() {
            try {
                Antlr2Tool.loadTool("antlr.Tool", null);
            }
            catch (ClassNotFoundException cnf) {
                return false;
            }
            return true;
        }
    }

    static class Antlr4Tool
    extends AntlrTool {
        Antlr4Tool() {
        }

        @Override
        int invoke(List<String> arguments, File inputDirectory) throws ClassNotFoundException {
            Object backedObject = Antlr4Tool.loadTool("org.antlr.v4.Tool", Antlr4Tool.toArray(arguments));
            if (inputDirectory != null) {
                JavaReflectionUtil.writeableField(backedObject.getClass(), "inputDirectory").setValue(backedObject, inputDirectory);
            }
            JavaReflectionUtil.method(backedObject, Void.class, "processGrammarsOnCommandLine", new Class[0]).invoke(backedObject, new Object[0]);
            return JavaReflectionUtil.method(backedObject, Integer.class, "getNumErrors", new Class[0]).invoke(backedObject, new Object[0]);
        }

        @Override
        public boolean available() {
            try {
                Antlr4Tool.loadTool("org.antlr.v4.Tool", null);
            }
            catch (ClassNotFoundException cnf) {
                return false;
            }
            return true;
        }
    }

    private static abstract class AntlrTool {
        private AntlrTool() {
        }

        static Object loadTool(String className, String[] args) throws ClassNotFoundException {
            try {
                Class<?> toolClass = Class.forName(className);
                if (args == null) {
                    return toolClass.newInstance();
                }
                Constructor<?> constructor = toolClass.getConstructor(String[].class);
                return constructor.newInstance(new Object[]{args});
            }
            catch (ClassNotFoundException cnf) {
                throw cnf;
            }
            catch (InvocationTargetException e) {
                throw new GradleException("Failed to load ANTLR", e.getCause());
            }
            catch (Exception e) {
                throw new GradleException("Failed to load ANTLR", e);
            }
        }

        public final AntlrResult process(AntlrSpec spec) {
            try {
                return this.doProcess(spec);
            }
            catch (ClassNotFoundException e) {
                throw new GradleException("Cannot process antlr sources", e);
            }
        }

        public AntlrResult doProcess(AntlrSpec spec) throws ClassNotFoundException {
            int numErrors = 0;
            if (spec.getInputDirectories().size() == 0) {
                numErrors += this.invoke(spec.asArgumentsWithFiles(), null);
            } else {
                boolean onWindows = OperatingSystem.current().isWindows();
                for (File inputDirectory : spec.getInputDirectories()) {
                    List<String> arguments = spec.getArguments();
                    arguments.add("-o");
                    arguments.add(spec.getOutputDirectory().getAbsolutePath());
                    for (File grammarFile : spec.getGrammarFiles()) {
                        String relativeGrammarFilePath = RelativePathUtil.relativePath(inputDirectory, grammarFile);
                        if (onWindows) {
                            relativeGrammarFilePath = relativeGrammarFilePath.replace('/', File.separatorChar);
                        }
                        arguments.add(relativeGrammarFilePath);
                    }
                    numErrors += this.invoke(arguments, inputDirectory);
                }
            }
            return new AntlrResult(numErrors);
        }

        abstract int invoke(List<String> var1, File var2) throws ClassNotFoundException;

        public abstract boolean available();

        protected static String[] toArray(List<String> strings) {
            return strings.toArray(new String[0]);
        }
    }

    private static class Antlr3Tool
    extends AntlrTool {
        private Antlr3Tool() {
        }

        @Override
        int invoke(List<String> arguments, File inputDirectory) throws ClassNotFoundException {
            Object backedObject = Antlr3Tool.loadTool("org.antlr.Tool", null);
            String[] argArray = arguments.toArray(new String[0]);
            if (inputDirectory != null) {
                JavaReflectionUtil.method(backedObject, Void.class, "setInputDirectory", String.class).invoke(backedObject, inputDirectory.getAbsolutePath());
                JavaReflectionUtil.method(backedObject, Void.class, "setForceRelativeOutput", Boolean.TYPE).invoke(backedObject, true);
            }
            JavaReflectionUtil.method(backedObject, Void.class, "processArgs", String[].class).invoke(backedObject, new Object[]{argArray});
            JavaReflectionUtil.method(backedObject, Void.class, "process", new Class[0]).invoke(backedObject, new Object[0]);
            return JavaReflectionUtil.method(backedObject, Integer.class, "getNumErrors", new Class[0]).invoke(backedObject, new Object[0]);
        }

        @Override
        public boolean available() {
            try {
                Antlr3Tool.loadTool("org.antlr.Tool", null);
            }
            catch (ClassNotFoundException cnf) {
                return false;
            }
            return true;
        }
    }
}

